/*
 * Decompiled with CFR 0.152.
 */
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class UDPSend {
    private boolean DEBUG = false;
    protected int[] intMessage;
    private String host = "255.255.255.255";
    private int port = 30718;
    private byte[] message;
    byte[] byteComm;
    String auxIP;
    int timeout;
    protected DatagramSocket dsocket = null;

    public UDPSend(int[] nArray) {
        this.intMessage = nArray;
        this.sendPacket();
    }

    public UDPSend(String string, int n, byte[] byArray, int n2) {
        this.auxIP = string;
        this.port = n;
        this.byteComm = byArray;
        this.timeout = n2;
    }

    public void sendBroadcastReq(NetworkInterface networkInterface) {
        if (networkInterface != null) {
            InetAddress inetAddress = null;
            InetAddress inetAddress2 = null;
            Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
            while (enumeration.hasMoreElements()) {
                try {
                    inetAddress2 = enumeration.nextElement();
                    if (!inetAddress2.isLoopbackAddress() && inetAddress2.getAddress().length == 4) {
                        Discover.s_out("Create UDP socket " + inetAddress2 + ":" + this.port + ";", null, 2);
                        this.dsocket = new DatagramSocket(this.port + 1, inetAddress2);
                        this.dsocket.setBroadcast(true);
                        this.dsocket.setReuseAddress(true);
                        inetAddress = InetAddress.getByName("255.255.255.255");
                        DatagramPacket datagramPacket = new DatagramPacket(this.message, this.message.length, inetAddress, this.port);
                        this.dsocket.send(datagramPacket);
                    }
                }
                catch (Exception exception) {
                    Discover.s_out("Can't get broadcast address", exception);
                    exception.printStackTrace(System.out);
                    return;
                }
                if (this.dsocket == null) continue;
                this.dsocket.close();
            }
        }
    }

    public void sendPacket() {
        this.message = new byte[this.intMessage.length];
        byte[] byArray = UDPSend.convertIntToByte(this.intMessage);
        System.arraycopy(byArray, 0, this.message, 0, this.intMessage.length);
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                this.sendBroadcastReq(networkInterface);
            }
        }
        catch (Exception exception) {
            Discover.s_out("Can't get header image!", exception);
            exception.printStackTrace(System.out);
            this.dsocket.close();
        }
    }

    public static byte[] convertIntToByte(int[] nArray) {
        int n = nArray.length;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            if (nArray[i] > 127) {
                nArray[i] = nArray[i] - 256;
            }
            byArray[i] = Integer.valueOf(nArray[i] & 0xFF).byteValue();
        }
        return byArray;
    }

    public static int[] convertByteToInt(byte[] byArray) {
        int n = byArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = byArray[i];
            if (nArray[i] >= 0) continue;
            nArray[i] = nArray[i] + 256;
        }
        return nArray;
    }
}

