/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MyTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 100L;
    private boolean DEBUG = false;
    protected int numRows = 0;
    private int maxDhcpNameLen = 15;
    public static final String[] columnNames = new String[]{"Set reply", "Ethernet address", "IP address", "HW type", "IPAM type", "Product ID", "FW version", "DHCP name"};
    static final int COL_REPLY = 0;
    static final int COL_MAC_ADDR = 1;
    static final int COL_IP_ADDR = 2;
    static final int COL_HW_TYPE = 3;
    static final int COL_IPAM_TYPE = 4;
    static final int COL_PRODUCT_ID = 5;
    static final int COL_FW_VERSION = 6;
    static final int COL_DHCP_NAME = 7;
    protected Vector<DeviceRecord> data = new Vector();

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public synchronized int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public synchronized int getRowCount() {
        return this.numRows;
    }

    @Override
    public synchronized Object getValueAt(int n, int n2) {
        try {
            DeviceRecord deviceRecord = this.data.elementAt(n);
            switch (n2) {
                case 0: {
                    if (deviceRecord.errorStatus == 0) {
                        return "No error";
                    }
                    if (deviceRecord.errorStatus == 1) {
                        return "Not Allowed ";
                    }
                    if (deviceRecord.errorStatus != 2) break;
                    return "Incorrect IP";
                }
                case 1: {
                    return this.ethAddrString(deviceRecord.ethernetAddr);
                }
                case 2: {
                    return this.ipDotString(deviceRecord.ipAddr);
                }
                case 3: {
                    return Discover.GetHWName(deviceRecord.hwType[2]);
                }
                case 4: {
                    return Discover.GetIPAMName(deviceRecord.hwType[3]);
                }
                case 5: {
                    return Discover.GetMIBPath(deviceRecord.productID);
                }
                case 6: {
                    return this.fwVersion(deviceRecord.fwVersion);
                }
                case 7: {
                    return new String(deviceRecord.dhcpName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    @Override
    public synchronized Class<?> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public synchronized boolean isCellEditable(int n, int n2) {
        return n2 == 2;
    }

    @Override
    public synchronized void setValueAt(Object object, int n, int n2) {
        String string = (String)object;
        switch (n2) {
            case 2: {
                int[] nArray = MyTableModel.ipStringToInt(string);
                if (nArray.length != 4) {
                    this.data.elementAt((int)n).errorStatus = 2;
                    break;
                }
                System.arraycopy(nArray, 0, this.data.elementAt((int)n).ipAddr, 0, 4);
                this.data.elementAt((int)n).errorStatus = -1;
            }
        }
        this.fireTableCellUpdated(n, n2);
    }

    public synchronized void updateDevice(DeviceRecord deviceRecord) {
        int n = -1;
        DeviceRecord deviceRecord2 = null;
        boolean bl = false;
        int n2 = 0;
        while (!bl && n2 < this.getRowCount()) {
            deviceRecord2 = this.data.elementAt(n2);
            if (Arrays.equals(deviceRecord.ethernetAddr, deviceRecord2.ethernetAddr)) {
                bl = true;
                n = n2;
                continue;
            }
            ++n2;
        }
        if (deviceRecord.errorStatus == -1) {
            if (bl) {
                if (this.DEBUG) {
                    System.out.println("row updated");
                }
                this.data.setElementAt(deviceRecord, n);
                this.fireTableRowsUpdated(n, n);
            } else {
                if (this.DEBUG) {
                    System.err.println("row added");
                }
                this.data.addElement(deviceRecord);
                ++this.numRows;
                this.fireTableDataChanged();
            }
            if (this.DEBUG) {
                System.out.println("New value of data:  row " + this.numRows);
                this.printDebugData();
            }
        } else if (bl) {
            if (this.DEBUG) {
                System.out.println("set response");
            }
            deviceRecord2.errorStatus = deviceRecord.errorStatus;
            deviceRecord2.applicationData = new int[deviceRecord.applicationData.length];
            System.arraycopy(deviceRecord.applicationData, 0, deviceRecord2.applicationData, 0, deviceRecord2.applicationData.length);
            this.fireTableRowsUpdated(n, n);
        }
    }

    public synchronized void clear() {
        if (this.DEBUG) {
            System.out.println("clear table");
        }
        int n = this.numRows;
        this.data.removeAllElements();
        this.numRows = 0;
        if (n > 0) {
            this.fireTableDataChanged();
        }
        if (this.DEBUG) {
            System.out.println("New value of data:");
            this.printDebugData();
        }
    }

    public String ipDotString(int[] nArray) {
        String string = Integer.toString(nArray[0]);
        for (int i = 1; i < nArray.length; ++i) {
            string = string.concat(".").concat(Integer.toString(nArray[i]));
        }
        return string;
    }

    public static int[] ipStringToInt(String string) {
        int[] nArray = new int[]{0};
        try {
            String[] stringArray = string.split("\\.");
            if (stringArray.length != 4) {
                return nArray;
            }
            int[] nArray2 = new int[4];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray2[i] = Integer.parseInt(stringArray[i]);
                if (nArray2[i] <= 255) continue;
                return nArray;
            }
            return nArray2;
        }
        catch (Exception exception) {
            return nArray;
        }
    }

    public String ethAddrString(int[] nArray) {
        String string = "";
        if (nArray[0] < 16) {
            string = string.concat("0");
        }
        string = string.concat(Integer.toHexString(nArray[0]));
        for (int i = 1; i < nArray.length; ++i) {
            string = string.concat("-");
            if (nArray[i] < 16) {
                string = string.concat("0");
            }
            string = string.concat(Integer.toHexString(nArray[i]));
        }
        return string;
    }

    protected String fwVersion(int[] nArray) {
        String string = "V";
        if (nArray.length == 3) {
            if (nArray[2] < 16) {
                string = string.concat("0");
            }
            string = string.concat(Integer.toHexString(nArray[2])).concat(".");
        }
        if (nArray[1] < 16) {
            string = string.concat("0");
        }
        string = string.concat(Integer.toHexString(nArray[1])).concat(".");
        if (nArray[0] < 16) {
            string = string.concat("0");
        }
        string = string.concat(Integer.toHexString(nArray[0]));
        return string;
    }

    private void printDebugData() {
        int n = this.getRowCount();
        int n2 = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            System.out.print("    row " + i + ":");
            for (int j = 0; j < n2; ++j) {
                System.out.print("  " + this.getValueAt(i, j));
            }
            System.out.println();
        }
        System.out.println("--------------------------");
    }
}

