/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Discover {
    private static final URL mibResource = Discover.class.getResource("BarixDiscover.mib");
    private static final URL hwListURL = Discover.class.getResource("HW_List.txt");
    private static final URL ipamListURL = Discover.class.getResource("IPAM_List.txt");
    public static int debug_level = 2;
    public static String Ver = "V0.41";
    public static String VERSION = " " + Ver + " (2025-10-21)";
    public static String OS = "unknown";
    public static String OS_Version = "";
    public static String javaVersion = "unknown";
    public static boolean MAC_OS_X = false;
    public static final int port = 30718;
    public static final String host = "255.255.255.255";
    public static final int[] barixID = new int[]{129, 136, 83, 129};
    public static final byte byteGetResponse = -127;
    public static final int intGetResponse = 129;
    public static final byte byteSetResponse = -126;
    public static final int intSetResponse = 130;
    public static final byte byteConfigResponse = -125;
    public static final int intConfigResponse = 131;
    public static final int get = 1;
    public static final int set = 2;
    public static final int[] messageGet = new int[]{129, 136, 83, 129, 1};
    public static final int[] messageSet = new int[]{129, 136, 83, 129, 2};
    public static final int RebootCommand = 3;
    public static final int ClearCommand = 4;
    public static final int RebootClearCommand = 7;
    public static SimpleMIBParser MIB = null;
    public static SimpleList HW_List = null;
    public static SimpleList IPAM_List = null;

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        DeviceTablePane deviceTablePane = new DeviceTablePane();
        deviceTablePane.setMinimumSize(new Dimension(deviceTablePane.getPreferredSize().width, 100));
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        deviceTablePane.pack();
        deviceTablePane.setVisible(true);
    }

    public static String GetMIBPath(int[] nArray) {
        Discover.s_out("Call GetMIBPath " + Arrays.toString(nArray), null, 5);
        if (MIB != null) {
            String string = MIB.getPath(nArray, 2);
            Discover.s_out("get path :" + Arrays.toString(nArray) + "->" + string, null, 5);
            return string;
        }
        Discover.s_out("MIB is null", null, 5);
        return Arrays.toString(nArray);
    }

    public static String GetHWName(int n) {
        if (HW_List != null) {
            String string = HW_List.getName(n);
            Discover.s_out("get HW name :" + n + "->" + string, null, 4);
            return string;
        }
        return String.valueOf(n);
    }

    public static String GetIPAMName(int n) {
        if (IPAM_List != null) {
            String string = IPAM_List.getName(n);
            Discover.s_out("get IPAM name :" + n + "->" + string, null, 4);
            return string;
        }
        return String.valueOf(n);
    }

    public static void main(String[] stringArray) {
        Discover.s_out("Discover Java Application, (c)Barix,2008-2025 " + VERSION);
        block14: for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() <= 0 || stringArray[i].charAt(0) != '-') continue;
            if (stringArray[i].length() <= 1) break;
            switch (stringArray[i].charAt(1)) {
                case 'd': {
                    ++debug_level;
                    continue block14;
                }
            }
        }
        javaVersion = System.getProperty("java.version");
        OS = System.getProperty("os.name");
        OS_Version = System.getProperty("os.version");
        Discover.s_out("Run on " + OS + " " + OS_Version + "; Java Version is " + javaVersion + ".", null, 1);
        if (OS.toLowerCase().indexOf("mac") != -1 && System.getProperty("mrj.version") != null) {
            MAC_OS_X = true;
            try {
                Method method = System.class.getDeclaredMethod("setProperty", String.class, String.class);
                if (method != null) {
                    method.invoke(null, (Object[])new String[]{"apple.laf.useScreenMenuBar", "true"});
                    method.invoke(null, (Object[])new String[]{"apple.awt.brushMetalLook", "true"});
                    method.invoke(null, (Object[])new String[]{"com.apple.macos.useScreenMenuBar", "true"});
                    method.invoke(null, (Object[])new String[]{"com.apple.mrj.application.apple.menu.about.name", "Discover"});
                    method.invoke(null, (Object[])new String[]{"com.apple.mrj.application.growbox.intrudes", "false"});
                    method.invoke(null, (Object[])new String[]{"com.apple.mrj.application.live-resize", "true"});
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (mibResource != null) {
            try {
                MIB = new SimpleMIBParser();
                MIB.addFileData(mibResource.openStream());
            }
            catch (Exception exception) {
                Discover.s_out("Can't get MIB data !", exception);
                MIB = null;
            }
        }
        if (hwListURL != null) {
            try {
                HW_List = new SimpleList();
                HW_List.addFileData(hwListURL.openStream());
            }
            catch (Exception exception) {
                Discover.s_out("Can't get HW List data !", exception);
                HW_List = null;
            }
        }
        if (ipamListURL != null) {
            try {
                IPAM_List = new SimpleList();
                IPAM_List.addFileData(ipamListURL.openStream());
            }
            catch (Exception exception) {
                Discover.s_out("Can't get IPAM List data !", exception);
                IPAM_List = null;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Discover.createAndShowGUI();
            }
        });
    }

    public static int MAX(int n, int n2) {
        if (n > n2) {
            return n;
        }
        return n2;
    }

    public static void s_out(String string) {
        Discover.s_out(string, null, 0);
    }

    public static void s_out(String string, Exception exception) {
        Discover.s_out(string, exception, 0);
    }

    public static void s_out(String string, Exception exception, int n) {
        if (n > debug_level) {
            return;
        }
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String string2 = simpleDateFormat.format(date) + " > " + string;
        if (exception != null) {
            string2 = string2 + " -> " + exception.toString();
        }
        System.out.println(string2);
        if (exception != null) {
            exception.printStackTrace(System.out);
        }
    }
}

