/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Timer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableRowSorter;

public class DeviceTablePane
extends JFrame
implements DeviceListener,
WindowListener,
ActionListener {
    private static final int preferredWindowWidth = 1088;
    private static final int preferredWindowHeight = 700;
    private static final int minWindowWidth = 100;
    private static final int minWindowHeight = 30;
    private boolean DEBUG = false;
    private static final long serialVersionUID = 100L;
    private JMenuBar app_menu = null;
    protected JDialog aboutBox = null;
    public static JPanel p;
    int MENU_KEY_MASK = 128;
    public static MyTableModel model;
    public static int selectedRow;
    protected JLabel labelSelected = new JLabel("Device selected:");
    public static JTable table;
    protected JScrollPane scrollPane;
    protected int dhcpNameIndex = 25;
    protected JFrame recoverBox = null;
    protected static JTextField macL;
    protected boolean isClosedConfigBox = false;
    protected JDialog infoBox = null;
    public static String status;
    public JLabel statusLabel = new JLabel("Status: ");
    public static int time;
    protected JRadioButton BootloadButton;
    public int[] auxMAC;
    public int[] auxIP;
    public static byte[] command;
    public int IntCommand;
    public int timeout;
    public static int[] magicNumber;
    public static boolean auxMenuConfig;
    public Timer timer;
    public String macText;
    public static boolean stop;
    static boolean running;
    static boolean isStopped;

    protected boolean check_browser_capabilities() {
        return true;
    }

    public DeviceTablePane() {
        super("Discovery Tool, " + Discover.Ver);
        this.setDefaultCloseOperation(0);
        this.create_menu();
        this.setup_about();
        this.addWindowListener(this);
        model = new MyTableModel();
        table = new JTable(model){
            protected String[] columnToolTips;
            private static final long serialVersionUID = 100L;
            {
                this.columnToolTips = new String[]{"Status of the SET command: success or failure", "Device's ethernet MAC address", "IP address the device is currently using. In case of DHCP/auto IP might not match the actual settings", "Type of the device", "Signature of the currently running firmware", "Version of the currently running firmware", "Device's DHCP name", "In the format of \"d1,d2,d3...\""};
            }

            public String getToolTipText(MouseEvent mouseEvent) {
                String string = null;
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                int n3 = this.convertColumnIndexToModel(n2);
                string = (String)this.getValueAt(n, n2);
                return string;
            }

            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){
                    private static final long serialVersionUID = 100L;

                    public String getToolTipText(MouseEvent mouseEvent) {
                        Object var2_2 = null;
                        Point point = mouseEvent.getPoint();
                        int n = this.columnModel.getColumnIndexAtX(point.x);
                        int n2 = this.columnModel.getColumn(n).getModelIndex();
                        return columnToolTips[n2];
                    }
                };
            }
        };
        model.addTableModelListener(table);
        TableRowSorter<MyTableModel> tableRowSorter = new TableRowSorter<MyTableModel>(model);
        tableRowSorter.setComparator(2, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return DeviceTablePane.this.compareIPAddresses(string, string2);
            }
        });
        table.setRowSorter(tableRowSorter);
        table.setSelectionMode(0);
        ListSelectionModel listSelectionModel = table.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    if (DeviceTablePane.this.DEBUG) {
                        System.out.println("No columns are selected.");
                    }
                } else {
                    selectedRow = listSelectionModel.getMinSelectionIndex();
                    DeviceTablePane.this.labelSelected.setText("Device selected: " + table.getValueAt(selectedRow, 1));
                }
            }
        });
        this.scrollPane = new JScrollPane(table);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.labelSelected.setForeground(Color.black);
        this.labelSelected.setAlignmentY(0.5f);
        p.add(this.labelSelected);
        p.add(Box.createHorizontalGlue());
        JButton jButton = new JButton("Get");
        jButton.setAlignmentY(0.5f);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UDPSend uDPSend = new UDPSend(Discover.messageGet);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        p.add(jButton);
        JButton jButton2 = new JButton("Set");
        jButton2.setAlignmentY(0.5f);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (selectedRow > -1 && selectedRow < table.getRowCount()) {
                    if (table.isEditing()) {
                        table.getCellEditor().stopCellEditing();
                    }
                    int n = table.convertRowIndexToModel(selectedRow);
                    DeviceRecord deviceRecord = DeviceTablePane.model.data.elementAt(n);
                    int n2 = 15;
                    int[] nArray = new int[n2];
                    int n3 = 0;
                    System.arraycopy(Discover.barixID, 0, nArray, 0, Discover.barixID.length);
                    nArray[n3 += Discover.barixID.length] = 2;
                    System.arraycopy(deviceRecord.ethernetAddr, 0, nArray, ++n3, deviceRecord.ethernetAddr.length);
                    System.arraycopy(deviceRecord.ipAddr, 0, nArray, n3 += deviceRecord.ethernetAddr.length, deviceRecord.ipAddr.length);
                    UDPSend uDPSend = new UDPSend(nArray);
                }
            }
        });
        p.add(jButton2);
        JButton jButton3 = new JButton("Clear");
        jButton3.setAlignmentY(0.5f);
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DeviceTablePane.this.clear();
                DeviceTablePane.this.labelSelected.setText("Device selected:");
                selectedRow = -1;
            }
        });
        p.add(jButton3);
        JButton jButton4 = new JButton("Web Browser");
        jButton4.setAlignmentY(0.5f);
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (selectedRow <= -1 || selectedRow >= table.getRowCount()) {
                    return;
                }
                int n = table.convertRowIndexToModel(selectedRow);
                DeviceRecord deviceRecord = DeviceTablePane.model.data.elementAt(n);
                BareBonesBrowserLaunch.openURL("http://" + model.ipDotString(deviceRecord.ipAddr));
            }
        });
        jButton4.setEnabled(this.check_browser_capabilities());
        p.add(jButton4);
        this.getContentPane().add((Component)p, "South");
        table.setPreferredScrollableViewportSize(new Dimension(1088, 700));
        table.setMinimumSize(new Dimension(100, 30));
        table.setAutoResizeMode(4);
        try {
            new DeviceListenerThread(this).start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void updateDevice(DeviceRecord deviceRecord) {
        model.updateDevice(deviceRecord);
        table.updateUI();
    }

    public void clear() {
        model.clear();
    }

    private JMenuBar create_menu() {
        if (this.app_menu == null) {
            this.app_menu = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            this.app_menu.add(jMenu);
            JMenuItem jMenuItem = new JMenuItem("About", 65);
            jMenuItem.setActionCommand("CMD_ABOUT");
            jMenuItem.addActionListener(this);
            if (!Discover.MAC_OS_X) {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, this.MENU_KEY_MASK));
            }
            jMenu.add(jMenuItem);
            jMenu.addSeparator();
            jMenuItem = new JMenuItem("Recovery", 82);
            jMenuItem.setActionCommand("CMD_recover");
            jMenuItem.addActionListener(this);
            if (!Discover.MAC_OS_X) {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, this.MENU_KEY_MASK));
            }
            jMenu.add(jMenuItem);
            jMenu.addSeparator();
            jMenuItem = new JMenuItem("Quit", 81);
            jMenuItem.setActionCommand("CMD_QUIT");
            jMenuItem.addActionListener(this);
            if (!Discover.MAC_OS_X) {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, this.MENU_KEY_MASK));
            }
            jMenu.add(jMenuItem);
            this.setJMenuBar(this.app_menu);
        }
        return this.app_menu;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.handleQuit();
    }

    public boolean handleQuit() {
        Object[] objectArray = new Object[]{"Quit", "Cancel"};
        int n = JOptionPane.showOptionDialog(this, "Do you really want to quit the Discovery Tool?", "Confirm Quit", 0, 2, null, objectArray, null);
        Discover.s_out("handleQuit: showOptionDialog return " + n + ":" + objectArray[n] + ".", null, 2);
        if (n == 0) {
            Discover.s_out("Discovery Tool has finished. Thanks for using...");
            System.exit(0);
            return true;
        }
        return false;
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowChangeState(WindowEvent windowEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Discover.s_out("call actionPerformed (" + string + ").", null, 4);
        if (string.compareTo("CMD_QUIT") == 0) {
            this.handleQuit();
            return;
        }
        if (string.compareTo("CMD_ABOUT") == 0) {
            this.handleAbout();
            return;
        }
        if (string.compareTo("CMD_recover") == 0) {
            if (this.recoverBox == null) {
                this.handleRecover();
            } else {
                this.recoverBox.setVisible(true);
            }
            return;
        }
    }

    public void setup_about() {
        this.MENU_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if (Discover.MAC_OS_X) {
            try {
                Class<?> clazz = Class.forName("OSXAdapter");
                Class<?> clazz2 = Class.forName("java.lang.reflect.Method");
                Class<?> clazz3 = Class.forName("java.lang.Object");
                if (clazz != null && clazz2 != null && clazz3 != null) {
                    Method method = clazz.getDeclaredMethod("setAboutHandler", clazz3, clazz2);
                    method.invoke(null, this, this.getClass().getDeclaredMethod("handleAbout", null));
                    method = clazz.getDeclaredMethod("setQuitHandler", clazz3, clazz2);
                    method.invoke(null, this, this.getClass().getDeclaredMethod("handleQuit", null));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                Discover.s_out("This version of Mac OS X does not support the Apple EAWT.  ApplicationEvent handling has been disabled (" + classNotFoundException + ")");
            }
            catch (Exception exception) {
                Discover.s_out("Mac OS X Adapter could not talk to EAWT:", exception);
            }
        }
    }

    public void handleAbout() {
        if (this.aboutBox == null) {
            this.aboutBox = new JDialog((Frame)this, "About Discovery Tool");
            JLabel jLabel = new JLabel("Discovery Tool " + Discover.VERSION, 0);
            Graphics graphics = this.getGraphics();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(jLabel.getText(), graphics);
            int n = 0;
            int n2 = 0;
            n2 = (int)((double)n2 + (rectangle2D.getHeight() + 5.0));
            n = Discover.MAX(n, (int)rectangle2D.getWidth());
            this.aboutBox.getContentPane().setLayout(new BorderLayout());
            this.aboutBox.getContentPane().add((Component)jLabel, "North");
            jLabel = new JLabel("\u00a9Barix, 2008-2025.", 0);
            rectangle2D = fontMetrics.getStringBounds(jLabel.getText(), graphics);
            n2 = (int)((double)n2 + (rectangle2D.getHeight() + 5.0));
            n = Discover.MAX(n, (int)rectangle2D.getWidth());
            this.aboutBox.getContentPane().add((Component)jLabel, "Center");
            JButton jButton = new JButton("OK");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DeviceTablePane.this.aboutBox.setVisible(false);
                }
            });
            n2 = (int)((double)n2 + (rectangle2D.getHeight() + 32.0));
            this.aboutBox.getContentPane().add((Component)jButton, "South");
            if (n2 < this.aboutBox.getPreferredSize().height) {
                n2 = this.aboutBox.getPreferredSize().height;
            }
            this.aboutBox.setSize(n + 32, n2);
            this.aboutBox.setResizable(false);
        }
        this.showAboutWindow();
    }

    public void showAboutWindow() {
        if (this.aboutBox != null) {
            Dimension dimension = this.aboutBox.getSize();
            Dimension dimension2 = this.getSize();
            Point point = this.getLocation();
            int n = (int)(point.getX() + (dimension2.getWidth() - dimension.getWidth()) / 2.0);
            int n2 = (int)(point.getY() + (dimension2.getHeight() - dimension.getHeight()) / 2.0);
            this.aboutBox.setLocation(n, n2);
            this.aboutBox.setVisible(true);
        }
    }

    public void handleRecover() {
        Object object;
        Object object2;
        this.recoverBox = new JFrame("Recover:");
        JPanel jPanel = new JPanel();
        this.statusLabel.setText("Status: ");
        if (this.isRowSelected()) {
            int n = table.convertRowIndexToModel(selectedRow);
            object2 = DeviceTablePane.model.data.elementAt(n);
            if (((DeviceRecord)object2).productID[1] == 99) {
                this.statusLabel.setText("Status: Device already in bootloader!");
            }
        }
        this.BootloadButton = new JRadioButton("Annuncicom 155 to Bootloader", true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.BootloadButton);
        object2 = new JPanel();
        ((Container)object2).setLayout(new GridLayout(1, 1));
        ((Container)object2).add(this.BootloadButton);
        ((JComponent)object2).setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Recover:"));
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel("Enter Ethernet Address: ");
        if (this.isRowSelected()) {
            int n = table.convertRowIndexToModel(selectedRow);
            object = DeviceTablePane.model.data.elementAt(n);
            if (((DeviceRecord)object).hwType[2] == 32) {
                macL = new JTextField(this.macText);
                jLabel = new JLabel("Annuncicom 155 Selected: ");
            } else {
                macL = new JTextField("00-08-e1-");
            }
        } else {
            macL = new JTextField("00-08-e1-");
        }
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel2.add(jLabel);
        jPanel2.add(macL);
        JButton jButton = new JButton("START");
        jButton.setAlignmentY(0.5f);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (running) {
                    return;
                }
                running = true;
                Thread thread = new Thread(){

                    public void run() {
                        DeviceTablePane.this.statusLabel.setText("Status: Sending...");
                        try {
                            String string = macL.getText();
                            if (DeviceTablePane.this.isRowSelected() && string.length() == 0) {
                                DeviceTablePane.this.infoWindow();
                                DeviceTablePane.this.infoBox.setVisible(true);
                                stop = true;
                                DeviceTablePane.this.statusLabel.setText("Status: ");
                            } else {
                                DeviceTablePane.this.handleStartRecover();
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        System.out.println("Finished on " + Thread.currentThread());
                        running = false;
                    }
                };
                thread.start();
            }
        });
        object = new JButton("STOP");
        ((JComponent)object).setAlignmentY(0.5f);
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                stop = true;
                isStopped = true;
            }
        });
        jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 0;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        jPanel.add(jButton);
        gridBagConstraints.gridheight = 0;
        gridBagLayout.setConstraints(new JLabel(""), gridBagConstraints);
        jPanel.add(new JLabel(""));
        gridBagConstraints.gridheight = 0;
        gridBagLayout.setConstraints((Component)object, gridBagConstraints);
        jPanel.add((Component)object);
        this.recoverBox.setLayout(new GridLayout(4, 1));
        this.recoverBox.add((Component)object2);
        this.recoverBox.add((Component)jPanel2, "center");
        this.recoverBox.add(jPanel);
        this.recoverBox.add((Component)this.statusLabel, "center");
        this.recoverBox.setBounds(100, 80, 250, 250);
        this.recoverBox.setSize(250, 250);
        this.showConfigWindow();
        this.recoverBox.setVisible(true);
        this.recoverBox.addWindowListener(new WindowListener(){

            public void windowClosed(WindowEvent windowEvent) {
            }

            public void windowActivated(WindowEvent windowEvent) {
            }

            public void windowClosing(WindowEvent windowEvent) {
                stop = true;
                DeviceTablePane.this.recoverBox.setVisible(false);
                DeviceTablePane.this.recoverBox.dispose();
                DeviceTablePane.this.recoverBox = null;
            }

            public void windowDeactivated(WindowEvent windowEvent) {
            }

            public void windowDeiconified(WindowEvent windowEvent) {
            }

            public void windowIconified(WindowEvent windowEvent) {
            }

            public void windowOpened(WindowEvent windowEvent) {
            }
        });
    }

    public void showConfigWindow() {
        Dimension dimension = this.recoverBox.getSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        int n = (int)(point.getX() + (dimension2.getWidth() - dimension.getWidth()) / 2.0);
        int n2 = (int)(point.getY() + (dimension2.getHeight() - dimension.getHeight()) / 2.0);
        this.recoverBox.setLocation(n, n2);
        this.recoverBox.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleStartRecover() {
        boolean bl = true;
        bl = this.BootloadButton.isSelected();
        this.IntCommand = 0;
        int n = 11;
        int[] nArray = new int[n];
        int n2 = 0;
        System.arraycopy(Discover.barixID, 0, nArray, 0, Discover.barixID.length);
        n2 += Discover.barixID.length;
        if (bl) {
            System.out.println("Selected: T - Kick to BL");
            nArray[n2] = 3;
        }
        int[] nArray2 = new int[]{0, 0, 0, 0, 0, 0};
        nArray2 = this.getMACAddress();
        System.arraycopy(nArray2, 0, nArray, ++n2, nArray2.length);
        this.timer = new Timer();
        time = 1;
        long l = 20L;
        long l2 = 240000L / l;
        isStopped = false;
        stop = false;
        do {
            UDPSend uDPSend = new UDPSend(nArray);
            ++time;
            try {
                Timer timer = this.timer;
                synchronized (timer) {
                    this.timer.wait(l);
                }
            }
            catch (InterruptedException interruptedException) {
                System.out.println("catch interrupted exception e");
            }
        } while (!stop && (long)time < l2);
        if (stop) {
            if (isStopped) {
                this.statusLabel.setText("Status: Stopped!");
            } else {
                this.statusLabel.setText("Status: Target device in bootloader mode!");
            }
        }
    }

    public int[] getMACAddress() {
        String string = macL.getText();
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0};
        try {
            int n;
            byte[] byArray = this.getMacBytes(string);
            byte[] byArray2 = new byte[6 + 16 * byArray.length];
            for (n = 0; n < 6; ++n) {
                byArray2[n] = -1;
            }
            for (n = 6; n < byArray2.length; n += byArray.length) {
                System.arraycopy(byArray, 0, byArray2, n, byArray.length);
            }
            nArray = DeviceTablePane.convertByteToInt(byArray);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("NumberFormatException: " + numberFormatException.getMessage());
        }
        return nArray;
    }

    public void infoWindow() {
        this.infoBox = new JDialog((Frame)this, "Info Window");
        JLabel jLabel = new JLabel("You have to insert a mac address! Example: 00-08-e1-00-76-18");
        Graphics graphics = this.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(jLabel.getText(), graphics);
        int n = 0;
        int n2 = 0;
        n2 = (int)((double)n2 + (rectangle2D.getHeight() + 5.0));
        n = Discover.MAX(n, (int)rectangle2D.getWidth());
        this.infoBox.getContentPane().setLayout(new BorderLayout());
        this.infoBox.getContentPane().add((Component)jLabel, "North");
        this.infoBox.setSize(new Dimension(380, 80));
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DeviceTablePane.this.infoBox.setVisible(false);
                macL.setText("00-08-e1-");
                DeviceTablePane.this.recoverBox.setVisible(false);
                DeviceTablePane.this.recoverBox.dispose();
                DeviceTablePane.this.recoverBox = null;
                DeviceTablePane.this.handleRecover();
            }
        });
        n2 = (int)((double)n2 + (rectangle2D.getHeight() + 32.0));
        this.infoBox.getContentPane().add((Component)jButton, "South");
        if (n2 < this.infoBox.getPreferredSize().height) {
            n2 = this.infoBox.getPreferredSize().height;
        }
        this.infoBox.setResizable(false);
        this.showInfoWindow();
    }

    public void showInfoWindow() {
        Dimension dimension = this.infoBox.getSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        int n = (int)(point.getX() + (dimension2.getWidth() - dimension.getWidth()) / 2.0);
        int n2 = (int)(point.getY() + (dimension2.getHeight() - dimension.getHeight()) / 2.0);
        this.infoBox.setLocation(n, n2);
        this.infoBox.setVisible(true);
    }

    public static byte[] intToByteArray(int n) {
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int n2 = (byArray.length - 1 - i) * 8;
            byArray[i] = (byte)(n >>> n2 & 0xFF);
        }
        return byArray;
    }

    public boolean isRowSelected() {
        if (selectedRow <= -1 || selectedRow >= table.getRowCount()) {
            auxMenuConfig = false;
            return false;
        }
        int n = table.convertRowIndexToModel(selectedRow);
        DeviceRecord deviceRecord = DeviceTablePane.model.data.elementAt(n);
        this.macText = model.ethAddrString(deviceRecord.ethernetAddr);
        auxMenuConfig = true;
        return true;
    }

    public byte[] getMacBytes(String string) throws IllegalArgumentException {
        byte[] byArray = new byte[6];
        String[] stringArray = string.split("(\\:|\\-)");
        if (stringArray.length != 6) {
            this.infoWindow();
            throw new IllegalArgumentException("Invalid MAC address.");
        }
        try {
            for (int i = 0; i < 6; ++i) {
                byArray[i] = (byte)Integer.parseInt(stringArray[i], 16);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid hex digit in MAC address.");
        }
        return byArray;
    }

    public static int[] convertByteToInt(byte[] byArray) {
        int n = byArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = byArray[i];
            if (nArray[i] >= 0) continue;
            nArray[i] = nArray[i] + 256;
        }
        return nArray;
    }

    private int compareIPAddresses(String string, String string2) {
        try {
            String[] stringArray = string.split("\\.");
            String[] stringArray2 = string2.split("\\.");
            for (int i = 0; i < 4 && i < stringArray.length && i < stringArray2.length; ++i) {
                int n;
                int n2 = Integer.parseInt(stringArray[i]);
                if (n2 == (n = Integer.parseInt(stringArray2[i]))) continue;
                return Integer.compare(n2, n);
            }
            return Integer.compare(stringArray.length, stringArray2.length);
        }
        catch (NumberFormatException numberFormatException) {
            return string.compareTo(string2);
        }
    }

    static {
        selectedRow = -1;
        status = null;
        magicNumber = Discover.barixID;
        auxMenuConfig = false;
        stop = false;
        running = false;
        isStopped = false;
    }
}

