/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Arrays;
import javax.swing.SwingUtilities;

public class DeviceListenerThread
extends Thread {
    private boolean DEBUG = false;
    protected static boolean stopListening = false;
    private DatagramSocket socket = null;
    private DeviceListener notifyee;
    protected byte[] barixIDByte = new byte[Discover.barixID.length];
    private int incomingBufferSize = 256;

    public DeviceListenerThread(DeviceListener deviceListener) throws IOException {
        super("DeviceListenerThread");
        this.socket = new DatagramSocket(30718);
        this.notifyee = deviceListener;
        System.arraycopy(UDPSend.convertIntToByte(Discover.barixID), 0, this.barixIDByte, 0, this.barixIDByte.length);
    }

    public synchronized void run() {
        while (!stopListening) {
            byte[] byArray = new byte[this.incomingBufferSize];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            try {
                this.socket.receive(datagramPacket);
                if (this.DEBUG) {
                    System.out.println("data received from port 30718\n");
                }
                byte[] byArray2 = datagramPacket.getData();
                byte[] byArray3 = new byte[4];
                System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
                if (!Arrays.equals(byArray3, this.barixIDByte) || byArray2[4] != -127 && byArray2[4] != -126 && byArray2[4] != -125) continue;
                int[] nArray = UDPSend.convertByteToInt(byArray2);
                int[] nArray2 = new int[nArray.length];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                if (byArray2[4] == -125) {
                    this.stopSending();
                    continue;
                }
                final DeviceRecord deviceRecord = new DeviceRecord(nArray2);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DeviceListenerThread.this.notifyee.updateDevice(deviceRecord);
                    }
                });
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.socket.close();
    }

    public void stopSending() {
        DeviceTablePane.stop = true;
    }
}

