<% . /usr/local/lib/cgi/generic.sh; print_http_hdr %>
<% . /usr/local/lib/cgi/status.sh %>
<% . /usr/local/lib/cgi/config.sh %>
<%

# set new first time password
function digest_password_set()
{
	if [[ X"" != X"$1" ]] ; then
		# note: realm must match the one set in /etc/config.d/httpd
		realm="Barix Login"
		
		hash=`echo -n "admin:$realm:$1" | md5sum | cut -b -32`
	
		rm -f /barix/local/etc/lighttpd/.passwd
		rm -f /etc/lighttpd/.passwd
	
		mkdir -p /barix/local/etc/ighttpd
		echo "admin:$realm:${hash}" >> /barix/local/etc/lighttpd/.passwd
		echo "admin:$realm:${hash}" >> /etc/lighttpd/.passwd
	
		cfg_set_param httpd.webserver.password_set "true"
	fi
}

function digest_password_reset()
{
	realm="Barix Login"
		
	if [[ X"" != X"$1" ]] ; then
		temp="admin:$realm:"`echo -n "admin:$realm:$1" | md5sum | cut -b -32`
		line=`tail /etc/lighttpd/.passwd`
		if [[ $temp == *"$line"* ]] ; then
			if [ -z $2 ] ; then
				# disable password now
				cfg_set_param httpd.webserver.password_set ""
				
				rm -f /barix/local/etc/lighttpd/.passwd
				rm -f /etc/lighttpd/.passwd
			else
				digest_password_set $2
			fi
		fi
	fi
}

# first handle if return page is not set
if [ "$FORM_return_page"X = "X" ] ; then FORM_return_page="index.html"; fi

declare -a pwd_old

# save configuration
env | grep FORM_ | while read line ; do
	equation=${line#FORM_*}
	lval=${equation%=*}
	rval=${equation#*=}
	       	
	case $lval in 
		*pwd_set*)
			digest_password_set $rval
		;;
		*pwd_old*)
			pwd_old=$rval
		;;
		*pwd_new*)
			digest_password_reset $pwd_old $rval
		;;
	esac
	
	cfg_set_param "$lval" "$rval"
done

# new address of the device is unknown
# it was static, now is DHCP - we don't know what we get
function unknown_address()
{
	if cfg_has_changed network.eth0.proto && cfg_string_compare network.eth0.proto "dhcp" ; then
		return 0;
	else
		return 1;
	fi
}

# print new URL of the refresh page
# call only if address is known (see the above function)
function print_new_url()
{
	echo -n "http://"
	if cfg_string_compare network.eth0.proto "dhcp" ; then
		print_ip_addr
	else
		cfg_print_param network.eth0.ipaddr 
	fi
	echo -n ":"
	cfg_print_param httpd.webserver.port
}

# returns true (0) if device's address or webport have changed
# returns false (1) otherwise
# call only if address is known
function ip_webport_changed() {
	if cfg_has_changed network.eth0.proto || cfg_has_changed network.eth0.ipaddr || cfg_has_changed httpd.webserver.port ; then
		return 0
	else 
		return 1
	fi
}

%>
<html>
<head>
<link href="../sys/css/settings.css" rel="stylesheet" type="text/css">
<script type="text/javascript" src="/sys/js/restart_services.js"></script>
<style type="text/css">
<!-- body { margin-left:20px } -->
</style>
</head>
<body>
<table cellspacing="5" border="0">
<tr><td>
<% 
	# if address known then use javascript to poll the device status
	if unknown_address ; then
		echo '
The new configuration has been successfuly applied.
The device will get a new DHCP address. Enter the new address into the browser.
'
	else
		if ip_webport_changed ; then
			echo -n '
The new configuration has been successfuly applied.
<p>Click <a href="' ; print_new_url ; echo -n "/$FORM_return_page"
			echo '">here</a> to return to the configuration page.
'
		else
			echo -n "
<body onload=\"restartingServices(500,document.getElementById('before'),document.getElementById('after'),'')\">
<div id=\"before\"> 
<p>The new configuration has been successfuly applied.
<p>System services are restarting, please wait...
</div>
<div id=\"after\"> 
<p>System services have restarted.
<p>Click <a href=\"/$FORM_return_page"
			echo '">here</a> to return to the configuration page.
</div>'
		fi
	fi
%>
</table>
</body>
</html>
<!-- as the last step save config -->
<% cfg_save %>


