// This code contains functions for polling device status while restarting.
// Use after config upload, factory defaults, reset, etc.

var system_ready="/sys/cgi-bin/system_ready.cgi";

var timer_id=null;			// for setInterval / clearInterval
var show_before_restart=null;		// object to show before and while restarting
var show_after_restart=null;		// object to show after restart
var addr_prefix=null;			// address prefix to be put before the request for "system_ready"


// This is the entry function to be called from body onload
// ms = timeout
// before = HTML element (object) to make visible while restarting services
// after = HTML element (object) to make visible after 
// prefix = address prefix to be prepended to the poll request; use if IP address changes
function restartingServices(ms, before, after, prefix)
{
	show_before_restart=before;
	show_after_restart=after;
	addr_prefix=prefix;

	show_before_restart.style.display="";		// show the "before"
	show_after_restart.style.display="none";	// hide the "after"

	timer_id=window.setInterval("reloadData()",ms);
}


// called on XMLHttpRequest status change
function onReadyStateChange() {
	if (this.readyState==4 && this.status==200) checkStatus(this.responseText); 
}

function reloadData() {

	if (window.XMLHttpRequest)
	{// code for IE7+, Firefox, Chrome, Opera, Safari
		req=new XMLHttpRequest();
		// fix for MSIE
		if (req.overrideMimeType) req.overrideMimeType("text/html; charset=ISO-8859-1");
	}
	else
	{// code for IE6, IE5
		req=new ActiveXObject("Microsoft.XMLHTTP");
	}
	req.open("GET",addr_prefix+system_ready,true);
	// workaround for MSIE caching problem
	req.setRequestHeader("If-Modified-Since", "Sat, 1 Jan 2000 00:00:00 GMT");
	req.onreadystatechange=onReadyStateChange;
	try { req.send(null);} catch(err) {}

  	return false;
}

function checkStatus(raw_data){
	/* system is ready */
	if (timer_id && raw_data.indexOf("yes") === 0)	// starts with "yes"
	{
		clearInterval(timer_id);	// stop timer 
		show_before_restart.style.display="none";	// hide the "before"
		show_after_restart.style.display="";		// show the "after"
	}
}
