# Barix utilities for application init scripts.

# start_app()
#
# Starts an application using start-stop-daemon with -b (for forking the app's
# execution). Uses a PID file for marking that the app is already running and
# know what's the running PID. On error, exists execution.
#
# Arguments:
#  - $1: The app name, for logging purposes and PID file name.
#  - $2: The app's executable path.
#  - $3: The app's arguments.
start_app() {
	echo "NOTE: barix-utils is deprecated. Please migrate to barix-wd utility." 1>&2
	app_name="$1"
	app_bin="$2"
	app_opts="$3"
	app_pid_file="/var/run/${app_name}.pid"

	echo "Starting '${app_name}'..."
	/sbin/start-stop-daemon -S -b -o -x ${app_bin} -p ${app_pid_file} -m -- \
		${app_opts}
	rc=$?
	if [ ${rc} -ne 0 ]; then
		echo "Starting '${app_name}'...FAILED (rc=${rc})"
		# Should not have been created, but just in case.
		rm -f ${app_pid_file}
		exit ${rc}
	fi
	echo "Starting '${app_name}'...OK"
}

# stop_app()
#
# Starts an application using start-stop-daemon with -b (for forking the app's
# execution). Uses a PID file for marking that the app is already running and
# know what's the running PID. On error, exists execution.
#
# Arguments:
#  - $1: The app name, for logging purposes and PID file name.
#  - $2: The timeout in seconds to wait for the process to finish.
#  - $3..$n: A series of regular expressions to be used for waiting for
#    processes to finish. The function will call wait_kill_app() on each with
#    the timeout given by $2.
stop_app() {
	echo "NOTE: barix-utils is deprecated. Please migrate to barix-wd utility." 1>&2
	app_name="$1"
	app_pid_file="/var/run/${app_name}.pid"
	timeout="$2"
	shift 2

	echo "Stopping '${app_name}'..."
	# Give a chance for the wd/app to stop cleanly with SIGINT.
	/sbin/start-stop-daemon -K -s 2 -o -p ${app_pid_file}
	rc=$?
	echo "Stopping '${app_name}'...DONE (rc=${rc})"
	# Make sure the apps are stopped, forcing if necessary.
	while (( "$#" )); do
		proc_re=$1
		wait_kill_app "${proc_re}" ${timeout}
		shift
	done
	# Drop the PID file.
	rm -f ${app_pid_file}
}

# wait_kill_app()
#
# Waits (with a timeout) for a given process to finish and kills it (SIGKILL) if
# it's still running after the timeout. The process search and killing uses
# pgrep and pkill, respectively, so that processes can be searched using a
# regular expression.
#
# Arguments:
#  - $1: The regular expression to use in pgrep/pkill for locating the process.
#  - $2: The timeout in seconds to wait for the process to finish.
wait_kill_app() {
	echo "NOTE: barix-utils is deprecated. Please migrate to barix-wd utility." 1>&2
	proc_re=$1
	timeout=$2

	# Loop waiting for process to exit, with timeout.
	ended=0
	count=1
	echo "Waiting for '${proc_re}' to end..."
	while [ ${count} -le ${timeout} ]; do
		if pgrep -f "${proc_re}" > /dev/null; then
			echo "Still running..."
			sleep 1
		else
			echo "Waiting for '${proc_re}' to end...DONE"
			ended=1
			break
		fi
		((count++))
	done

	# Force process killing if waiting timed out.
	if [ ${ended} -ne 1 ]; then
		echo "Waiting for '${proc_re}' to end...FAILED => Kill it!"
		pkill -9 -f "${proc_re}"
		rc=$?
		echo "Killed '${proc_re}' (rc=${rc})"
	fi
}
