import logging
from logging.handlers import RotatingFileHandler

"""
Init logger
"""
def initLogger(name, log_level, log_file_path, log_max_size, log_backup_count, format, timestamp_format=None):
    log = logging.getLogger(name)
    log.setLevel(log_level)
    rotHandler = RotatingFileHandler(log_file_path, maxBytes=log_max_size, backupCount=log_backup_count)
    format1 = logging.Formatter(fmt=format, datefmt=timestamp_format)
    rotHandler.setFormatter(format1)
    log.addHandler(rotHandler)