import json
import urllib
import time
import threading

from barix import HTTPRequestsAPI

from .uci import getValueOfUci

class BacoAudioLoopREST:

    def __init__(self, port):
        self.ipaddress = "127.0.0.1"
        self.port = port

    def setSilenceMode(self):
        url = '/api/v1/input/config'
        payload = {"mode": "SILENCE"}
        r = HTTPRequestsAPI.put('http://{}:{}{}'.format(self.ipaddress, self.port, url), payload)
        return r.status

    def setLoopMode(self):
        url = '/api/v1/input/config'
        payload = {
            "mode": "LOOP",
            "parameters": {
                "device": "hw:3,0",
                "sampleRate": 48000,
                "fifoDelay": 92,
                "dispatchSize": 16
            }
        }
        r = HTTPRequestsAPI.put('http://{}:{}{}'.format(self.ipaddress, self.port, url), payload)
        return r.status

    def getStats(self):
        url = '/api/v1/stats'
        r = HTTPRequestsAPI.get('http://{}:{}{}'.format(self.ipaddress, self.port, url))
        if r.status == 200:
            info = r.read()
            enc = r.info().get_content_charset('utf-8')
            json_out = json.loads(info.decode(enc))
            return json_out
        else:
            return r.reason

    def setVolume(self, vol):
        url = '/api/v1/volume'
        payload = {"volume": vol}
        r = HTTPRequestsAPI.put('http://{}:{}{}'.format(self.ipaddress, self.port, url), payload)
        return r.status

    def initBacoAudioLoopThread(self):
        bacoMonThread = threading.Thread(target=self.__checkBacoLoopRunningMode)
        bacoMonThread.setDaemon(True)
        bacoMonThread.start()

    def __checkBacoLoopRunningMode(self):
        time.sleep(5)
        vol = getValueOfUci('application', 'audio', 'volume')
        bacoIsNotInLoopRunningMode = True
        while bacoIsNotInLoopRunningMode:
            statsJson = self.getStats()
            if statsJson["mode"] == "LOOP":
                if statsJson["loopMode"] == 1:
                    self.setVolume(int(vol))
                    bacoIsNotInLoopRunningMode = False
            time.sleep(1)


class AES67DaemonREST:

    def __init__(self):
        self.ipaddress = "127.0.0.1"
        self.port = 8080  # flexa_uci.uci_get("aes67.network.http_port")

    def __del__(self):
        NotImplemented

    def __getDaemon(self, url):
        """
        r = requests.get('http://{}:{}{}'.format(self.ipaddress,self.port,url))
        if r.status_code == 200:
            return r.json()
        else:
            return r.status_code
        """
        try:
            r = HTTPRequestsAPI.get('http://{}:{}{}'.format(self.ipaddress, self.port, url))
            if r.status == 200:
                info = r.read()
                enc = r.info().get_content_charset('utf-8')
                json_out = json.loads(info.decode(enc))
                return json_out
            else:
                return r.reason
        except urllib.error.HTTPError as e:
            return e.code

    def __setDaemon(self, url, payload):
        """
        r = requests.post('http://{}:{}{}'.format(self.ipaddress,self.port,url), json=payload)
        return r.status_code
        """
        r = HTTPRequestsAPI.post('http://{}:{}{}'.format(self.ipaddress, self.port, url), payload)
        return r.status

    def __putDeamon(self, url, payload):
        """
        r = requests.put('http://{}:{}{}'.format(self.ipaddress,self.port,url), data=json.dumps(payload))
        return r.status_code
        """
        r = HTTPRequestsAPI.put('http://{}:{}{}'.format(self.ipaddress, self.port, url), payload)
        return r.status

    def __deleteDaemon(self, url):
        """
        r = requests.delete('http://{}:{}{}'.format(self.ipaddress,self.port,url))
        return r.status_code
        """
        r = HTTPRequestsAPI.delete('http://{}:{}{}'.format(self.ipaddress, self.port, url))
        return r.status

    def getDaemonConfig(self):
        return self.__getDaemon('/api/config')

    def setDaemonConfig(self, payload):
        return self.__setDaemon('/api/config', payload)

    def getPTPConfig(self):
        return self.__getDaemon('/api/ptp/config')

    def setPTPConfig(self, payload):
        return self.__setDaemon('/api/ptp/config', payload)

    def getPTPStatus(self):
        return self.__getDaemon('/api/ptp/status')

    def addRTPSource(self):
        NotImplemented

    def remRTPSource(self):
        NotImplemented

    def getRTPSourceSDPFile(self):
        NotImplemented

    def addRTPSink(self, id, data):
        if 0 <= id <= 63:
            return self.__putDeamon('/api/sink/{}'.format(id), data)
        return "ERROR"

    def remRTPSink(self, id):
        if 0 <= id <= 63:
            return self.__deleteDaemon('/api/sink/{}'.format(id))
        return "ERROR"

    def getRTPSinkStatus(self, id):
        if 0 <= id <= 63:
            return self.__getDaemon('/api/sink/status/{}'.format(id))
        return "ERROR"

    def getRTPSinkErrorCounters(self, id):
        if 0 <= id <= 63:
            return self.__getDaemon('/api/sink/counters/{}'.format(id))
        return "ERROR"

    def getAllRTPSources(self):
        return self.__getDaemon('/api/sources')

    def getAllRTPSinks(self):
        return self.__getDaemon('/api/sinks')

    def getAllStreams(self):
        return self.__getDaemon('/api/streams')

    def getRemoteSources(self, method="all"):
        if method != "mdns" and method != "sap" and method != "all":
            return "ERROR"
        return self.__getDaemon('/api/browse/sources/{}'.format(method))