import smbus

class I2C:
    def __init__(self, i2c_bus, chip_address):
        self.chip_address = chip_address
        self.bus = smbus.SMBus(i2c_bus)

    def isI2cAddressAvailable(self):
        try:
            self.bus.read_byte_data(self.chip_address,0x00)
            return True
        except Exception as e:
            print(f"Cannot access chip address {self.chip_address}: {e}")
            return False

    def readByte(self, register):
        return self.bus.read_byte_data(self.chip_address, register)

    def writeByte(self, register, value):
        self.bus.write_byte_data(self.chip_address, register, value)

    def setBit(self, register, bit):
        value = self.readByte(register)
        value |= bit
        self.writeByte(register, value)

    def clearBit(self, register, bit):
        value = self.readByte(register)
        value &= ~(bit)
        self.writeByte(register, value)

    def writeBit(self, register, bit, state):
        if state:
            self.setBit(register, bit)
        else:
            self.clearBit(register, bit)
