import logging
import uci
import json

logger = logging.getLogger(__name__)

def flexa_get_app_version():
    version = ''
    try:
        u = uci.Uci()
        version = u.get("flexa_agent", "service", "package_version")
    except Exception as err:
        logger.error("Error getting app version: {}".format(err))
        raise err

    return version

def flexa_read_app_config():
    config = {}
    try:
        with open('/mnt/data/package/config.json', 'r') as f:
            config = json.load(f)['AppParam']
    except Exception as err:
        logger.error('Error reading configuration file: {}'.format(err))
        raise err

    return config
