import urllib.request
import urllib.error
import ssl
import urllib.parse
import json
from typing import *

def get(url: str, headers: Dict[str,str]=None, **kwargs) -> urllib.response.addinfourl:
    """
    Perform an HTTP GET request on the given url
     * url - the url to fetch
     * headers - optional headers to send with the request
     
    Named arguments:
     * timeout - the timeout, in seconds for the request (default: 30)
     * tlsVerify - whether TLS strict validation shall be performed (default: True)
    """
    timeout = 30
    if "timeout" in kwargs:
        timeout = int(kwargs["timeout"])
        
    tlsVerify   = True
    if "tlsVerify" in kwargs:
        tlsVerify   = bool(kwargs["tlsVerify"])
        
    request = urllib.request.Request(url= url, method='GET')
    if headers is not None:
        for (key,val) in headers:
            request.add_header(key,val)

    if request.type.lower()=="https":
        tlsContext                 = ssl.create_default_context()
        tlsContext.check_hostname  = tlsVerify
        tlsContext.verify_mode     = ssl.CERT_NONE
        return urllib.request.urlopen(request, timeout=timeout, context=tlsContext)
    else:
        return urllib.request.urlopen(request, timeout=timeout)


def head(url: str, headers: Dict[str,str]=None, **kwargs) -> urllib.response.addinfourl:
    """
    Perform an HTTP HEAD request on the given url
     * url - the url to fetch
     * headers - optional headers to send with the request
     
    Named arguments:
     * timeout - the timeout, in seconds for the request (default: 30)
     * tlsVerify - whether TLS strict validation shall be performed (default: True)
    """
    timeout = 30
    if "timeout" in kwargs:
        timeout = int(kwargs["timeout"])
        
    tlsVerify   = True
    if "tlsVerify" in kwargs:
        tlsVerify   = bool(kwargs["tlsVerify"])
        
    request = urllib.request.Request(url= url, method='HEAD')
    if headers is not None:
        for (key,val) in headers:
            request.add_header(key,val)

    if request.type.lower()=="https":
        tlsContext                 = ssl.create_default_context()
        tlsContext.check_hostname  = tlsVerify
        tlsContext.verify_mode     = ssl.CERT_NONE
        return urllib.request.urlopen(request, timeout=timeout, context=tlsContext)
    else:
        return urllib.request.urlopen(request, timeout=timeout)


# payload should be JSON
def post(url, payload, timeout=30, SSLVerify=True):
    print(payload)
    print(json.dumps(payload).encode('utf-8'))
    request = urllib.request.Request(url=url, data=json.dumps(payload).encode('utf-8'), method='POST')
    request.add_header('Content-Type', 'application/json')

    if request.type.lower()=="https":
        context = ssl.create_default_context()
        context.check_hostname = SSLVerify
        context.verify_mode = ssl.CERT_NONE
        return urllib.request.urlopen(request, timeout=timeout, context=context)
    else:
        return urllib.request.urlopen(request, timeout=timeout)


def put(url, payload, timeout=30, SSLVerify=False):
    request = urllib.request.Request(url=url, data=json.dumps(payload).encode('utf-8'), method='PUT')
    request.add_header('Content-Type', 'application/json')
    if request.type.lower()=="https":
        context = ssl.create_default_context()
        context.check_hostname = SSLVerify
        context.verify_mode = ssl.CERT_NONE
        return urllib.request.urlopen(request, timeout=timeout, context=context)
    else:
        return urllib.request.urlopen(request, timeout=timeout)


def patch(url, payload, timeout=30, SSLVerify=False):
    """
    Execute an HTTP PATCH, using payload encoded as a JSON body
    """
    request = urllib.request.Request(url=url, data=json.dumps(payload).encode('utf-8'), method='PATCH')
    request.add_header('Content-Type', 'application/json')
    if request.type.lower()=="https":
        context = ssl.create_default_context()
        context.check_hostname = SSLVerify
        context.verify_mode = ssl.CERT_NONE
        return urllib.request.urlopen(request, timeout=timeout, context=context)
    else:
        return urllib.request.urlopen(request, timeout=timeout)


def delete(url, timeout=30, SSLVerify=False):
    request = urllib.request.Request(url=url, method='DELETE')
    if request.type.lower()=="https":
        context = ssl.create_default_context()
        context.check_hostname = SSLVerify
        context.verify_mode = ssl.CERT_NONE
        return urllib.request.urlopen(request, timeout=timeout, context=context)
    else:
        return urllib.request.urlopen(request, timeout=timeout)
