#!/usr/bin/python3

# =================================================================
# Set RP specific DEP settings 
# =================================================================

import sys
import syslog
import json
import logging
import subprocess
from uci import Uci

logger = logging.getLogger(__name__)

logging.basicConfig(filename='/var/log/set_dep_config.log', level=logging.INFO, format='%(asctime)s %(name)s %(levelname)s %(message)s')
logger.info("Start setting DEP configuration")

# check if "Dante" feature is available
with open('/tmp/factory_info_partition/factory_info_json') as f:
    res = json.load(f)
    for elem in res['SW_LICENSES']:
        if 'Image_Features' in elem:
            if "Dante" in elem['Image_Features']:
                logger.info("Dante feature is available")
                break
            else: 
                logger.info("Dante feature is not present")
                sys.exit(0)

    # set Dante UCI configuration -> transmitter only device
    # uses Dante Alsa plugin (dsoundcard) to send audio to DEP
    uci = Uci()
    uci.set("dante","dep","enabled","true")
    uci.set("dante","dep","tx_channels","2")
    uci.set("dante","dep","rx_channels","0")
    logger.info("Enabling DEP - receiver")
    uci.set("dante","dante_app","dep_audio_interface","DANTE_ALSA_PLUGIN")
    uci.set("dante","dante_app","alsa_out","hw:0,0,4")
    logger.info("Dante App settings - DEP interface: DANTE_ALSA_PLUGIN, alsa out: hw:0,0,4")
    
    # chech if USB ethernet dongle is connected (eth1 interface will appear)
    result = subprocess.run(['ip', 'link'], stdout=subprocess.PIPE, stderr=subprocess.PIPE, text=True)
    if result.returncode != 0:
        logger.error(f"Error running ip link: {result.stderr}")
    else:
        if 'eth1' in result.stdout:
            logger.info("eth1 is available => USB dongle ethernet is connected!")
            uci.set("dante","dep","network_interfaces","eth1")
        else:
            logger.info("eth1 is not available => USB dongle is not conneted! Using eth0")
            uci.set("dante","dep","network_interfaces","eth0")
    uci.commit("dante")
