#!/bin/sh

source /usr/bin/jshn.sh
export _json_no_warning=1

error_exit() {
  echo "Error: $1" 1>&2
  exit 1
}

print_var() {
  if [ ! -z $1 ]; then echo $1; else echo "Undefined";  fi;
}

print_usage() {
  echo "usage: $1 <image_name> <license_id> <image_features> <issue_date> <expire_date> <status> <signature>"
  echo "Add or update the specified license, where:"
  echo "  <image_name>        associated image name"
  echo "  <license_id>        license identifier"
  echo "  <image_features>    comma separated image features"
  echo "  <issue_date>        date the license was issued"
  echo "  <expire_date>       date the license expires"
  echo "  <status>            license status (active|revoked|...)"
  echo "  <signature>         license signature"
  exit 1
}

if ! [ "$#" -eq 7 ]; then
  print_usage $0
fi

IMAGE_NAME=$1
LICENSE_ID=$2
IMAGE_FEATURES=$3
ISSUE_DATE=$4
EXPIRE_DATE=$5
STATUS=$6
SIGNATURE=$7

#echo "Adding license id=$LICENSE_ID for image=$IMAGE_NAME ..."
if ! qiba-spi-get-info >/dev/null 2>/dev/null; then
  HW_INFO="{ }"
else
  HW_INFO=`qiba-spi-get-info`
fi
json_load "$HW_INFO"

license_id=""
image_name=""
if json_select SW_LICENSES; then 
  Index="1"
  while json_get_type type $Index && [ "$type" = object ]; do
    json_select "$((Index++))"
    json_get_var image_name "Image_Name"
    if [ "$image_name" = "$IMAGE_NAME" ]; then
      json_get_var license_id "License_ID"
      json_get_var image_features "Image_Features"
      json_get_var issue_date "Issue_Date"
      json_get_var expire_date "Expire_Date"
      json_get_var status "Status"
      json_get_var signature "Signature"

      if [ "$license_id" = "$LICENSE_ID" ] && 
         [ "$image_features" = "$IMAGE_FEATURES" ] && 
         [ "$issue_date" = "$ISSUE_DATE" ] && 
         [ "$expire_date" = "$EXPIRE_DATE" ] && 
         [ "$signature" = "$SIGNATURE" ] && 
         [ "$status" = "$STATUS" ]; then
        echo "An identical license exists, exiting ..."
        exit 0
      fi

      echo "Updating existing license id=$license_id for image=$image_name ..."
      break;
    fi
    json_select ".."
  done
else 
  json_add_array SW_LICENSES
fi

if [ "$image_name" != "$IMAGE_NAME" ]; then
  json_add_object
fi

json_add_string "Image_Name" $IMAGE_NAME
json_add_string "License_ID" $LICENSE_ID
json_add_string "Image_Features" $IMAGE_FEATURES
json_add_string "Issue_Date" $ISSUE_DATE
json_add_string "Expire_Date" $EXPIRE_DATE
json_add_string "Signature" $SIGNATURE
json_add_string "Status" $STATUS

if [ "$image_name" != "$IMAGE_NAME" ]; then
  json_close_object
  json_close_array
fi

json_dump > /tmp/json
if ! qiba-spi-set-info /tmp/json 1>&2 >/dev/null; then
  error_exit "cannot store production info into SPI flash"
fi

exit 0
