#!/bin/sh

#
# called with DIR ACTION
# DIR - mount point of the newly (u)mounted dir
# ACTION - ADD or REMOVE

DIR=$1
ACTION=$2

say()
{
  echo "$@"
  logger "$@"
}


add()
{

  if [ ! -d $DIR ]; then
    say "$DIR does not exist. nothing to do"
    exit 0
  fi

  if [ "$(find $DIR -maxdepth 1 -type f -iname "*.mp3" -o -iname "*.aac" -o -iname "*.m4a" -o -iname "*.flac" -o -iname "*.ogg" -o -iname "*.wav" | wc -l)" = "0" ]; then
    say "No media files found in '$DIR'. exit"
    exit 0
  fi

  mkdir -p /tmp/retailplayer/
  ln -sf $DIR /tmp/retailplayer/local-tracks

  exit 0
}


case "$ACTION" in
ADD)
  add
  ;;

REMOVE)
  restart_player
  exit 0
  ;;

*)
  say "Invalid arguments: " "$@"
  exit 1
  ;;
esac

