# Decoder Mode Configuration

### Description
Select the decoder mode for RTP streams.

---

### Modes
- **SDP**: Allows you to upload and modify a Session Description Protocol (SDP) file.
- **URL**: Provide a server IP address and port for RTP streams.  

  Supported URL schemes:  
  - **Multicast RTP**: `rtp://<ip>:<port>`  
  - **Unicast RTP**: `rtp://@:<port>`  

  By default, without specifying additional parameters, the device will play any stream with static payloads.

  #### Advanced Configuration
  It is possible to manually specify the format and additional parameters by appending them to the URL. Supported parameters include:  
  - **format**: `mulaw` or `alaw`  
  - **channels**: `1` or `2`  
  - **rate**: `8000`, `16000`, `24000`, `32000`, `44100`, or `48000`  
  - **payload type (pt)**: Integer value  

  #### Example
  To play a G711 uLaw 32kHz Mono stream generated by an Instreamer Classic (dynamic payload type = 100), use the following URL scheme:  
  `rtp://<IP_ADDRESS>:<PORT>?format=mulaw&channels=1&rate=32000&pt=100`

---

### Notes
1. **End-to-End Delay**: RTP streams have an approximate end-to-end delay of 200ms. Playback is synchronized with other IPAC devices.  
2. **Port Configuration**:  
   - When using multiple RTP sources, avoid consecutive port numbers for each source. Leave at least one "free" port between sources.  
     Example:  
     - RTP Source 1 = `rtp://@:4444`  
     - RTP Source 2 = `rtp://@:4446`  
     - RTP Source 3 = `rtp://@:4448`  
   This is necessary because some applications use the “next” port for RTCP control packets.  
3. **Paging Mode Restriction**: If using a paging source in simple paging mode, avoid ports `5555`, `5556`, and `5557` as they are reserved for internal use.
