### Description
Manages the SCHEDULER source configuration, enabling scheduling of audio playback using Fixed Time, Rotation, and Playlist schedulers. Each type works on a weekly basis and is prioritized for seamless operation.  

---

### Usage

<br>

#### Fixed Time
- Schedule announcements to play at specific times (e.g., bells, alerts).
- Steps:
  1. Click **"Schedule New Announcement"**.
  2. Select or upload an audio file and optionally add a description.
  3. Set the play time and weekdays, then **SAVE**.
  4. Use the provided controls to modify or remove announcements.
  5. Click **SUBMIT** to finalize the schedule.

#### Rotation
- Schedule ads or messages to play in rotation.
- Steps:
  1. Add clips to the rotation and arrange playback order.
  2. Enable or disable clips as needed.
  3. Set daily time windows and playback intervals.
  4. Optionally, enable **Restarts Daily** to start the rotation anew each day.
  5. Click **SUBMIT** to apply the configuration.

#### Playlist
- Schedule playlists for background music (BGM).
- Steps:
  1. Create a playlist in the **Audio Files Playlist** tab.
  2. Click **"Schedule a Playlist"**, select the playlist, and set start and end times.
  3. Specify playback days and click **SAVE**.
  4. Use the provided controls to edit or remove playlists.
  5. Click **SUBMIT** to confirm the schedule.

---

### Notes
- Ensure the Scheduler Source is configured in the Source tab before scheduling playback.
- Priority is as follows:
  1. Fixed Time: Announcements play first if scheduled simultaneously with Rotation.
  2. Rotation: Plays after Fixed Time announcements in the queue.
  3. Playlist: Plays in the absence of announcements.
- Configurations can be edited or removed at any time.  
