### Description
The remote configurator tool is designed for managing multiple IP Speaker devices, either individually or in bulk, across a network. It allows users to easily configure device settings, assign zones, change device names, and apply settings such as volume, IP addressing, and security options. The tool uses the Avahi service to discover devices within the same local network (LAN), and it provides real-time updates as changes are made.

---

### Usage

- **Discovery**:  
  The tool automatically identifies all IP Speakers in the LAN using Avahi. By default, Avahi is active, but it can be disabled via the setup page to prevent device discovery.

- **Device Name**:  
  - Click the pencil icon next to the name cell to change a device’s name.
  - Apply changes by clicking **SAVE** for individual devices or **SAVE ALL** to apply changes to all devices.
  - **Sort by Name**: Click the arrow in the Name column header to toggle between ascending and descending order.

- **Zones**:  
  - Devices are assigned to zones, which help to apply settings in bulk. Devices are initially assigned to "Zone 0."
  - To add a new zone, click the plus button in the Zone column header and select from existing zones or add a new one.
  - To rename a zone, click the pencil icon next to the zone name and confirm the change. This will apply to all devices in the zone.
  - Change a device’s zone using the dropdown, with an option to apply the change to just one device or all devices in the zone.
  - Zones with no devices are automatically removed, and the list of available zones is refreshed by reloading the page.

  **Notes**:  
  - Zones are automatically removed when no devices are assigned to them.  
  - To refresh the available zones after a zone is removed, reload the page.

- **Filtering**:  
  - Use the filter at the top left to display specific devices based on configuration parameters. The filter applies in real-time as you type.

  **Note**:  
  The filter applies as you type, allowing for fast configuration of specific devices based on configuration parameters.  

- **Settings**:  
  - Expand the **Settings** column to view and edit device configurations, such as IP address, master volume, Sonic IP settings, and HTTPS options.
  - Changes can be made individually or in bulk, and must be saved using the **SAVE** or **SAVE ALL** buttons.

- **Priority Columns**:  
  Each priority column represents playback sources in descending order (1 to 5). The default settings are SynApps and InformaCast, depending on the device’s license.
  - Change priorities by clicking the arrows next to the priority names. When a source is playing, its cell turns green.
  - After making changes, ensure to click **SAVE**.

- **System Information**:  
  The **System** column displays device details like MAC address, hardware type, firmware version, system time, uptime, and license information. It can be sorted by MAC address.

- **Control Actions**:  
  - **SAVE**: Save changes made to an individual device.  
  - **TEST**: Play a 4-second sine wave for testing or identification.  
  - **OPEN WEB UI**: Access the device’s web interface.  
  - **REBOOT**: Reboot the device immediately.

- **Copy/Push**:  
  - **COPY**: Copy a device’s configuration and apply it to other devices by clicking the **INSERT** button on selected devices.  
  - **PUSH**: Push the entire configuration of one device in a zone to all other devices in the same zone.  

  **Note**:  
  The **COPY** function only affects source configurations, not settings.

- **Read All / Save All**:  
  - **Read All**: Refresh the table to display the current configuration of all devices.  
  - **Save All**: Apply changes to all devices in the list.

- **Reboot All**:  
  Reboot all devices in the network and refresh the table after they have rebooted.

  **Note**:  
  After using the **Reboot All** button, the table will be cleared. Use the **Read All** button to rescan the network once devices are rebooted.

- **Number of Listed Devices per Page**:  
  Set how many devices are displayed per page (this setting is not saved and needs to be set again after page reload).

---

### Notes
- **Device Sorting**: Devices can be sorted by name, zone, or IP address (in the Settings column).  
- **Bulk Changes**: Many settings (e.g., master volume, HTTPS enable/disable, IP addressing) can be applied in bulk to multiple devices.  
- **Save Settings**: Always click **SAVE** or **SAVE ALL** after modifying settings to ensure changes are applied.
