#!/bin/bash

# Base directory for the Stream Helper configuration
BASE_DIR="./helpers/instreamer_ice/stream"

# Declare an associative array for file content
declare -A FILE_CONTENTS

# Populate the array with filenames and their content
FILE_CONTENTS=(
    ["Stream_Name.md"]="### Description\nConfigure a name for your stream. This name is only used here in the setup and has no influence on the streaming functionality.\n\n---\n\n### Usage\nEnter a name that helps identify this stream in your setup.\n\n---\n\n### Notes\n- This name does not affect the streaming functionality."
    ["Stream_Input/Input_Source.md"]="### Description\nChoose the desired input source.\n\n---\n\n### Usage\nSelect 'Line-IN' for the RCA/Cinch connector input.\n\n---\n\n### Notes\n- The RCA white cable is for the left channel, and the red cable is for the right channel."
    ["Stream_Input/Input_Level.md"]="### Description\nSelect the input/operating level that best suits your input device.\n\n---\n\n### Usage\nAdjust to optimize the dynamic range and prevent clipping.\n\n---\n\n### Notes\n- Consult your input device's specifications for ideal settings."
    ["Stream_Input/Input_Channel.md"]="### Description\nSelect how you want to capture from your RCA/Cinch connector.\n\n---\n\n### Usage\n- **Mono-Left:** Use the white cable.\n- **Mono-Right:** Use the red cable.\n- **Stereo:** Use both cables.\n\n---\n\n### Notes\n- Mono options are for single-channel audio capture."
    ["Stream_Input/Sampling_Rate.md"]="### Description\nDefine the desired sampling frequency.\n\n---\n\n### Usage\nChoose a higher frequency for better audio quality but increased bandwidth usage.\n\n---\n\n### Notes\n- Ensure the frequency aligns with your bandwidth and quality requirements."
    ["Stream_Encoder/Encoder_Type.md"]="### Description\nSelect the encoding format for audio data.\n\n---\n\n### Usage\nChoose between 'MP3' and 'AAC' based on compatibility and quality needs.\n\n---\n\n### Notes\n- MP3 is widely supported, while AAC offers higher quality at similar bitrates."
    ["Stream_Encoder/Bitrate_Type.md"]="### Description\nChoose the bitrate type for audio compression.\n\n---\n\n### Usage\n- **CBR (Constant Bit Rate):** Uses the entire bit rate consistently.\n- **VBR (Variable Bit Rate):** Optimizes bandwidth by adjusting bit rate dynamically.\n\n---\n\n### Notes\n- VBR provides better bandwidth efficiency, but compatibility should be considered."
    ["Stream_Encoder/Bitrate.md"]="### Description\nDefine the audio compression level (bitrate).\n\n---\n\n### Usage\nSelect the desired bitrate in kilobits per second for the audio stream.\n\n---\n\n### Notes\n- Not all bitrates are available depending on the sampling rate."
    ["Stream_Destination/Server_Type.md"]="### Description\nSpecify the type of server for the stream.\n\n---\n\n### Usage\n- **Icecast Server:** Sends the stream to a built-in server.\n- **Icecast Source:** Sends the stream to a remote server.\n\n---\n\n### Notes\n- Icecast Source requires additional configuration like Remote URL and Audio Port."
    ["Stream_Destination/Icecast_Name.md"]="### Description\nSet the title of your stream as part of the metadata.\n\n---\n\n### Usage\nEnter a name that will appear as the stream's title in media players.\n\n---\n\n### Notes\n- Make this descriptive to help users identify your stream."
    ["Stream_Destination/Icecast_Description.md"]="### Description\nProvide additional details about your stream.\n\n---\n\n### Usage\nAdd any complementary information about the stream.\n\n---\n\n### Notes\n- This is optional but helps enrich the stream metadata."
    ["Stream_Destination/Icecast_Genre.md"]="### Description\nDefine the genre of your stream.\n\n---\n\n### Usage\nEnter the content type, such as 'Music,' 'Podcast,' or 'Talk Show.'\n\n---\n\n### Notes\n- Use relevant genres to help listeners discover your stream."
    ["Stream_Destination/Mount_Point.md"]="### Description\nSet the mount point for your stream.\n\n---\n\n### Usage\nSpecify the unique endpoint for accessing your stream (e.g., /stream1).\n\n---\n\n### Notes\n- Avoid spaces in the mount point name."
    ["Stream_Destination/Remote_URL.md"]="### Description\nDefine the URL for the stream destination.\n\n---\n\n### Usage\nProvide the address of the server to which the stream will be sent (e.g., 127.0.0.1).\n\n---\n\n### Notes\n- Visible only in 'Icecast Source' mode."
    ["Stream_Destination/Audio_Port.md"]="### Description\nSpecify the port for the Icecast server.\n\n---\n\n### Usage\nEnter the port number used for listeners to access the stream.\n\n---\n\n### Notes\n- Visible only in 'Icecast Source' mode."
    ["Stream_Destination/Username.md"]="### Description\nDefine the username for server authentication.\n\n---\n\n### Usage\nEnter the credentials required for accessing the Icecast server.\n\n---\n\n### Notes\n- Ensure this matches the server's username configuration."
    ["Stream_Destination/Password.md"]="### Description\nDefine the password for server authentication.\n\n---\n\n### Usage\nEnter the password required for accessing the Icecast server.\n\n---\n\n### Notes\n- Ensure this matches the server's password configuration."
)

# Create the base directory for the Stream Helper configuration
mkdir -p "$BASE_DIR"

# Create the directory structure and files
for file in "${!FILE_CONTENTS[@]}"; do
    # Create the necessary directories for each file
    dir=$(dirname "$BASE_DIR/$file")
    mkdir -p "$dir"

    # Write the content to the markdown file
    echo -e "${FILE_CONTENTS[$file]}" > "$BASE_DIR/$file"
done

echo "Stream Helper folder structure and files have been created successfully."
