import logging
from common_lib.rest.web.web_base_routes import web_base_bp
from application.application_routes import application_bp
from common_lib.rest.web.routes.web_static_routes import static_bp

logger = logging.getLogger('flask-backend')


def include_static_routes(app):
    try:
        app.register_blueprint(static_bp)
    except Exception as ex1:
        logger.debug("It was not possible to import frontend routes: {}".format(ex1))


def include_web_api_routes(app):
    app.register_blueprint(web_base_bp)

def include_application_routes(app):
    app.register_blueprint(application_bp)

