import paho.mqtt.client as mqtt
import time
import random

# MQTT Broker configuration
BROKER = "192.168.20.144"
PORT = 9001
TOPIC_BASE = "ICE/"
INTERVAL = 0.1


def generate_vumeter_data():
    return {
        "L": random.randint(-60, +6),
        "R": random.randint(-60, +6)
    }

def on_connect(client, userdata, flags, rc):
    print("Trying to connect")
    if rc == 0:
        print("Connected to MQTT Broker!")
    else:
        print(f"Failed to connect, return code {rc}")

def simulate_mqtt_publisher():
    print("script started")
    client = mqtt.Client(transport="websockets")
    client.on_connect = on_connect

    try:

        client.connect(BROKER, PORT, 60)

        client.loop_start()

        vumeter_number = 1
        while True:

            data = generate_vumeter_data()

            client.publish(f"{TOPIC_BASE}vumeter/{vumeter_number}/L", payload=data["L"], qos=0, retain=False)
            client.publish(f"{TOPIC_BASE}vumeter/{vumeter_number}/R", payload=data["R"], qos=0, retain=False)

            print(f"Published to {TOPIC_BASE}vumeter/{vumeter_number}: L={data['L']}, R={data['R']}")

            time.sleep(INTERVAL)

    except KeyboardInterrupt:
        print("Simulation stopped.")
    finally:
        client.loop_stop()
        client.disconnect()

if __name__ == "__main__":
    simulate_mqtt_publisher()
