from flask import Flask
import os

"""
Init Configuration
"""
from common_lib.lib.configuration import load_config
config_path = os.environ.get("CONFIG_PATH", "./config.json")
load_config(config_path)

from common_lib.lib.logger import init_logger
from common_lib.lib.AppUtils import AppUtils

from routes import include_application_routes


"""
Init logger
"""
logger = init_logger()


def show_routes(app):
    logger.debug("Available Endpoints:")
    for rule in app.url_map.iter_rules():
        methods = ','.join(rule.methods)
        logger.debug(f"{rule.rule:40s} [{methods+']':35} - {rule.endpoint}")



"""
Init application
"""

app = Flask(__name__, static_url_path='', static_folder='static', template_folder='static')
app = AppUtils.set_base_configuration(app, logger)



"""
uci_configs = [
        {"config": "network",           "section": "eth0",                                      "service": "audiostreamer"},
        {"config": "sonic_ip",          "section": "general",       "option": "volume",         "service": "audiostreamer"},
        {"config": "network",           "section": "eth0",                                      "service": "sonic_ip"},
        {"config": "sonic_ip",          "section": "general",       "option": "volume",         "service": "sonic_ip"},
        {"config": "network",           "section": "eth0",                                      "service": "icecast"},
        {"config": "instreamer4",                                                               "service": "icecast"}
]
"""

"""
Include additional routes
"""
#  TODO: Add here product specific endpoints
include_application_routes(app)
# WebUtils.show_endpoints_at_log(app, logger)
show_routes(app)


# Start application
if __name__ == "__main__":
    AppUtils.run_app(app, logger)
