import logging
import threading
from typing import List, Tuple
from common_lib.lib.RestartServiceUtils import RestartServiceUtils
from common_lib.uci.Uci2ServiceMap import Uci2ServiceMap

logger = logging.getLogger('flask-backend')


class Utils:


    @staticmethod
    def restart_related_services(ucis_configured: List[str]):
        """
        Calls the callback function to create a list of services that should be restarted according to the ucis that were changed.
        Write the list into the file that stores the services to restart.
        If the file existed already, the new list will be merged with the existing one and duplicates will be removed.
        Then, calls restartServicesFromFile to restart the services on a separate thread, according to the order of priority.
        @param ucis_configured: list(array) of tuples containing the ucis that were configured. At the moment, each tuple contains a uci's config, an uci's
        section and an uci's option.
        """
        try:
            services_list = Uci2ServiceMap().get_affected_services_for_ucis(ucis_configured)
            # write services_list in file
            if len(services_list) == 0:
                logger.info("No services to restart")
                return

            # read services from file
            services_from_file = RestartServiceUtils.read_from_restart_services_file()
            # join services from list and from file
            list_of_services = services_list + services_from_file
            # for service in services_from_file:
            #     list_of_services.append(service)
            # for service in services_list:
            #     list_of_services.append(service)

            logger.debug(f"list_of_services: {list_of_services}")

            # remove duplicates
            set_of_services = set(list_of_services)
            logger.debug(f"List of services to write into file: {set_of_services}")
            RestartServiceUtils.write_into_restart_services_file(set_of_services)

            # restart services
            t = threading.Thread(target=RestartServiceUtils.restart_services_from_file, args=())
            t.start()

        except Exception as e:
            logger.error(e, exc_info=True)
            raise e
