import { PostLoginRequestBody } from "@custom-types/base/authentication.types";
import { HttpResponse } from "@custom-types/base/request-response.types";
import { webUiPassword, webUiUsername } from "@environment";
import { BaseApi } from "@models/base/base.api";

const maxRetries = 50;
const retryDelayMs = 5000;

export function resetDevice() {
    clearCache();

    const requestBody: PostLoginRequestBody = {
        username: webUiUsername,
        password: webUiPassword
    }

    BaseApi.login(requestBody).then((response) =>{
        expect(response.status).to.be.equal(200);
        BaseApi.resetSystemDefaults().then((response: Cypress.Response<HttpResponse>) => {
            expect(response.status).to.be.equal(200);

            // Waiting for the device to start the reset before checking if it is available
            // cy.wait(retryDelayMs);
            // retryGetSystemInfo();

            cy.wait(120000);
        });
    });
}


function retryGetSystemInfo(retryCount = 0) {
    if (retryCount > maxRetries) {
        throw new Error('Max retries reached for getSystemInfo');
    }
    cy.log(`Attempt ${retryCount + 1} to get system info...`);
    cy.request({
        method: 'GET',
        url: 'https://192.168.20.132/web/system/info',
        failOnStatusCode: false,
        timeout: 2000, // Lower timeout for faster retries
    }).then((response) => {
        if (response.status === 200) {
            expect(response.status).to.eq(200);
        } else {
            cy.wait(retryDelayMs).then(() => {
                retryGetSystemInfo(retryCount + 1);
            });
        }
    })
}

// If getSystemInfo response is not 200 the getSystemInfo endpoint should retry (every 5 seconds or so)
/* BaseApi.getSystemInfo().then((response: Cypress.Response<HttpResponse>) => {
    expect(response.status).to.be.equal(200);
}) */


//cy.wait(120000); // Wait two minutes


export function clearCache() {
    cy.clearAllCookies();
    cy.clearAllLocalStorage();
    cy.clearAllSessionStorage();
}
