import { HttpMethod } from "@custom-types/base/request-response.types";

export function logRequest(request: { method: HttpMethod, url: string, body: Cypress.RequestBody | undefined, query?: object }) {
    const timestamp = new Date().toISOString();
    const queryString = JSON.stringify(request.query, null, 3);
    const requestBody = JSON.stringify(request.body, null, 3);

    const logMessage = `
    === ${timestamp} ===============================================
    Request:
        Method: ${request.method}
        URL: ${request.url}
        Query: ${queryString}
        Body: ${requestBody || 'Undefined'}
    ----------------------------------------------------------------------------
    `;

    console.log(logMessage);
}

export function logResponse(response: { status: number, body: unknown, duration: number }) {
    const timestamp = new Date().toISOString();
    const responseBody = JSON.stringify(response.body, null, 3);

    const logMessage = `
    --- ${timestamp} -----------------------------------------------
    Response:
        Status: ${response.status}
        Duration: ${response.duration} ms
        Body: ${responseBody}
    ============================================================================
    `;

    console.log(logMessage);
}