import { HttpMethod, HttpResponse } from "@custom-types/base/request-response.types";
import { baseUrl } from "@environment";
import { logRequest, logResponse } from "./logger";

/**
    * Sends an HTTP request to an API.
    * @param method HTTP method (POST, PUT, PATCH, DELETE, GET)
    * @param endpoint API endpoint path
    * @param body Request body (optional)
    * @param query Query parameters (optional)
    * @returns Cypress request chain
    */
export function request(
    method: HttpMethod,
    endpoint: string,
    body?: Cypress.RequestBody,
    query?: Record<string, any>
): Cypress.Chainable<Cypress.Response<any>> {
    const url = `${baseUrl}/web${endpoint}`;

    logRequest({ method, url, body, query });


    return cy.request({
        method,
        url,
        body,
        qs: query,
        failOnStatusCode: false
    }).then((response) => {
        logResponse(response);
        return response;
    });
}
