export enum HttpMethod {
    POST = "POST",
    GET = "GET",
    PATCH = "PATCH",
    PUT = "PUT",
    DELETE = "DELETE"
}

export interface HttpResponse {
    headers: ResponseHeaders;
    status: number;
    statusText: string;
    isOkStatusCode: boolean;
    requestHeaders: RequestHeaders;
    requestBody: string;
    duration: number;
    body: any;
}

interface ResponseHeaders {
    server: string;
    date: string;
    'content-type': string;
    'content-length': string;
    connection: string;
    vary: string;
    'set-cookie': string[];
}

interface RequestHeaders {
    Connection: string;
    'user-agent': string;
    accept: string;
    'accept-encoding': string;
    'content-type': string;
    'content-length': number
}