import { PostLoginRequestBody } from "@custom-types/base/authentication.types";
import { HttpResponse } from "@custom-types/base/request-response.types";
import { webUiPassword, webUiUsername } from "@environment";
import { BaseApi } from "@models/base/base.api";
import { clearCache } from "@utils/base/reset-device";

// This endpoint reboots the device
// Note the issue https://barix.atlassian.net/browse/SINSTRICE-188
// Whenever this test is run, the httpd.webserver.password_set UCI is cleared and all session related tests will fail due to this problem
describe.skip('Reboot device', () => {
    beforeEach(() => {
        clearCache();
        console.log(`%c${Cypress.currentTest.title}:`, 'font-weight: bold');
    });

    it('Reboot device on a logged in account', () => {
        const requestBody: PostLoginRequestBody = {
            username: webUiUsername,
            password: webUiPassword
        }

        BaseApi.login(requestBody).then((response) =>{
            expect(response.status).to.be.equal(200);
            BaseApi.reboot({}).then((response: Cypress.Response<HttpResponse>) => {
                expect(response.status).to.be.equal(200);
                if (response.status === 200) {
                    cy.wait(120000); // Wait two minutes for the reboot to finish
                }
            })
        });

    });

    it('Reboot device on a non logged in account', () => {
        BaseApi.reboot({}).then((response: Cypress.Response<HttpResponse>) => {
            if (response.status === 200) {
                cy.wait(120000); // Wait two minutes for the reboot to finish
            }
            expect(response.status).to.be.equal(401);
        });
    });
});
