import { PostLoginRequestBody } from "@custom-types/base/authentication.types";
import { HttpResponse } from "@custom-types/base/request-response.types";
import { webUiPassword, webUiUsername } from "@environment";
import { BaseApi } from "@models/base/base.api";
import { clearCache } from "@utils/base/reset-device";

describe('Logout', () => {
    beforeEach(() => {
        clearCache();
        console.log(`%c${Cypress.currentTest.title}:`, 'font-weight: bold');
    });

    it('Logout on a logged in account', () => {
        const requestBody: PostLoginRequestBody = {
            username: webUiUsername,
            password: webUiPassword
        }

        BaseApi.login(requestBody).then((response) =>{
            expect(response.status).to.be.equal(200);
        });

        BaseApi.logout().then((response: Cypress.Response<HttpResponse>) => {
            expect(response.status).to.be.equal(200);
        })
    });

    it('Logout on a non logged in account', () => {
        BaseApi.logout().then((response: Cypress.Response<HttpResponse>) => {
            expect(response.status).to.be.equal(401);
        });
    });
});
