import { PostLoginRequestBody } from "@custom-types/base/authentication.types";
import { HttpResponse } from "@custom-types/base/request-response.types";
import { webUiPassword, webUiUsername } from "@environment";
import { BaseApi } from "@models/base/base.api";
import { clearCache } from "@utils/base/reset-device";

const availableKeys = ["capabilities", "device", "licenses", "massStorageDev", "network"];

describe('Get System Status', () => {
    beforeEach(() => {
        clearCache();
        console.log(`%c${Cypress.currentTest.title}:`, 'font-weight: bold');
    });

    it('Get system status on a logged in account', () => {
        const requestBody: PostLoginRequestBody = {
            username: webUiUsername,
            password: webUiPassword
        }

        BaseApi.login(requestBody).then((response) => {
            expect(response.status).to.be.equal(200);
        });

        BaseApi.getSystemStatus().then((response: Cypress.Response<HttpResponse>) => {
            expect(response.status).to.be.equal(200);
        })
    });

    it('Get system status on a non logged in account', () => {
        BaseApi.getSystemStatus().then((response: Cypress.Response<HttpResponse>) => {
            expect(response.status).to.be.equal(401);
        });
    });

    it(`Get system status with all the keys`, () => {
        const requestBody: PostLoginRequestBody = {
            username: webUiUsername,
            password: webUiPassword
        };

        BaseApi.login(requestBody).then((response) => {
            expect(response.status).to.equal(200);

            BaseApi.getSystemStatus().then((response: Cypress.Response<HttpResponse>) => {
                expect(response.status).to.equal(200);
                expect(response.body).to.have.keys(availableKeys);
            });
        });
    });
});
