import { PostLoginRequestBody } from "@custom-types/base/authentication.types";
import { HttpResponse } from "@custom-types/base/request-response.types";
import { webUiPassword, webUiUsername } from "@environment";
import { BaseApi } from "@models/base/base.api";
import { clearCache } from "@utils/base/reset-device";

describe('Get system logs', () => {
    beforeEach(() => {
        clearCache();
        console.log(`%c${Cypress.currentTest.title}:`, 'font-weight: bold');
    });

    it('Retrieve logs on a logged in account', () => {
        const requestBody: PostLoginRequestBody = {
            username: webUiUsername,
            password: webUiPassword
        }

        BaseApi.login(requestBody).then((response) =>{
            expect(response.status).to.be.equal(200);
        });

        BaseApi.getSystemLogs().then((response) => {
            expect(response.status).to.be.equal(200);
            expect(response.body).to.be.have.keys(['message']);
        })
    });

    it('Retrieve logs on a non logged in account', () => {
        BaseApi.getSystemLogs().then((response) => {
            expect(response.status).to.be.equal(401);
        });
    });
});
