import { PostLoginRequestBody } from "@custom-types/base/authentication.types";
import { HttpResponse } from "@custom-types/base/request-response.types";
import { webUiPassword, webUiUsername } from "@environment";
import { BaseApi } from "@models/base/base.api";
import { clearCache } from "@utils/base/reset-device";

describe('Get MQTT settings', () => {
    beforeEach(() => {
        clearCache();
        console.log(`%c${Cypress.currentTest.title}:`, 'font-weight: bold');
    });

    it('Retrieve MQTT settings on a logged in account', () => {
        const requestBody: PostLoginRequestBody = {
            username: webUiUsername,
            password: webUiPassword
        }

        BaseApi.login(requestBody).then((response) =>{
            expect(response.status).to.be.equal(200);
        });

        BaseApi.getMqttSettings().then((response) => {
            expect(response.status).to.be.equal(200);
            const expectedKeys = ['hostname', 'password', 'path', 'port', 'protocol', 'publishTopic', 'subscribeTopic', 'username'];
            expect(response.body).to.have.keys(expectedKeys);

            // Check that each key's value is neither null nor undefined
            expectedKeys.forEach((key: string) => {
                expect(response.body[key as keyof typeof response.body], `Key '${key}' should not be null or undefined`).to.not.be.null.to.not.be.undefined;
            });
        })
    });

    it('Retrieve MQTT settings on a non logged in account', () => {
        BaseApi.getMqttSettings().then((response) => {
            expect(response.status).to.be.equal(401);
        });
    });
});
