import { PostLoginRequestBody } from "@custom-types/base/authentication.types";
import { webUiPassword, webUiUsername } from "@environment";
import { BaseApi } from "@models/base/base.api";
import { clearCache } from "@utils/base/reset-device";

describe('Get logs', () => {
    beforeEach(() => {
        clearCache();
        console.log(`%c${Cypress.currentTest.title}:`, 'font-weight: bold');
    });

    // The request to retrieve all logs is hanging, not sure why
    it('Retrieve logs on a logged in account', () => {
        const requestBody: PostLoginRequestBody = {
            username: webUiUsername,
            password: webUiPassword
        }

        BaseApi.login(requestBody).then((response) => {
            expect(response.status).to.be.equal(200);
        });

        BaseApi.getAllLogs().then((response) => {
            expect(response.status).to.be.equal(200);
        })
    });

    it('Retrieve logs on a non logged in account', () => {
        BaseApi.getAllLogs().then((response) => {
            expect(response.status).to.be.equal(401);
        });
    });


});
