import { PostLoginRequestBody } from "@custom-types/base/authentication.types";
import { HttpResponse } from "@custom-types/base/request-response.types";
import { webUiPassword, webUiUsername } from "@environment";
import { BaseApi } from "@models/base/base.api";
import { clearCache } from "@utils/base/reset-device";

describe('Get Firmware Update Settings', () => {
    beforeEach(() => {
        clearCache();
        console.log(`%c${Cypress.currentTest.title}:`, 'font-weight: bold');
    });

    it('Get firmware update settings on a logged in account', () => {
        const requestBody: PostLoginRequestBody = {
            username: webUiUsername,
            password: webUiPassword
        }

        BaseApi.login(requestBody).then((response) =>{
            expect(response.status).to.be.equal(200);
        });

        BaseApi.getFirmwareUpdateSettings().then((response: Cypress.Response<HttpResponse>) => {
            expect(response.status).to.be.equal(200);
            expect(response.body).to.have.keys([
                'application.fw_update.auto',
                'application.fw_update.start_time',
                'application.fw_update.stop_time',
                'application.fw_update.url',
                'application.fw_update.week_day',
                'security.update.enabled'
            ]);
        });
    });

    it('Get firmware update settings on a non logged in account', () => {
        BaseApi.getFirmwareUpdateSettings().then((response: Cypress.Response<HttpResponse>) => {
            expect(response.status).to.be.equal(401);
        });
    });
});
