import { PostLoginRequestBody } from "@custom-types/base/authentication.types";
import { HttpResponse } from "@custom-types/base/request-response.types";
import { webUiPassword, webUiUsername } from "@environment";
import { BaseApi } from "@models/base/base.api";
import { clearCache } from "@utils/base/reset-device";

// Deprecated
describe.skip('Get CA Certificates', () => {
    beforeEach(() => {
        clearCache();
        console.log(`%c${Cypress.currentTest.title}:`, 'font-weight: bold');
    });

    it('Get CA certificates', () => {
        const requestBody: PostLoginRequestBody = {
            username: webUiUsername,
            password: webUiPassword
        }

        BaseApi.login(requestBody).then((response) =>{
            expect(response.status).to.be.equal(200);
        });

        BaseApi.getCaCertificates().then((response: Cypress.Response<HttpResponse>) => {
            expect(response.status).to.be.equal(200);
        });
    });
});
