import { PostLoginRequestBody } from "@custom-types/base/authentication.types";
import { HttpResponse } from "@custom-types/base/request-response.types";
import { webUiPassword, webUiUsername } from "@environment";
import { BaseApi } from "@models/base/base.api";
import { clearCache } from "@utils/base/reset-device";

describe('Change Password', () => {
    const newPassword = 'Barix-123456';

    function resetPassword() {
        const changePasswordRequestBody = {
            oldPassword: newPassword,
            newPassword: webUiPassword,
            confirmPassword: webUiPassword
        }

        BaseApi.changePassword(changePasswordRequestBody).then((response: Cypress.Response<HttpResponse>) => {
            expect(response.status).to.be.equal(200);
        });
    }

    beforeEach(() => {
        clearCache();
        console.log(`%c${Cypress.currentTest.title}:`, 'font-weight: bold');
    });



    it('Change password on a logged in account', () => {
        const loginRequestBody: PostLoginRequestBody = {
            username: webUiUsername,
            password: webUiPassword
        }


        const changePasswordRequestBody = {
            oldPassword: webUiPassword,
            newPassword,
            confirmPassword: newPassword
        }

        BaseApi.login(loginRequestBody).then((response) => {
            expect(response.status).to.be.equal(200);

            BaseApi.changePassword(changePasswordRequestBody).then((response: Cypress.Response<HttpResponse>) => {
                expect(response.status).to.be.equal(200);

                BaseApi.login(loginRequestBody).then((response) => {
                    expect(response.status).to.be.equal(401);

                    BaseApi.login({ ...loginRequestBody, password: newPassword }).then((response) => {
                        expect(response.status).to.be.equal(200);
                        resetPassword();
                    })
                });
            });
        });
    });


    it('Change password without providing all the fields', () => {
        const loginRequestBody: PostLoginRequestBody = {
            username: webUiUsername,
            password: webUiPassword
        }


        const changePasswordRequestBody = {
            newPassword,
            confirmPassword: newPassword
        }

        BaseApi.login(loginRequestBody).then((response) => {
            expect(response.status).to.be.equal(200);

            BaseApi.changePassword(changePasswordRequestBody).then((response: Cypress.Response<HttpResponse>) => {
                expect(response.status).to.be.equal(400);
            });
        });
    });

    it('Change password with mismatching newPassword and confirmPassword', () => {
        const loginRequestBody: PostLoginRequestBody = {
            username: webUiUsername,
            password: webUiPassword
        }

        const changePasswordRequestBody = {
            oldPassword: webUiPassword,
            newPassword,
            confirmPassword: 'notTheNewPassword'
        }

        BaseApi.login(loginRequestBody).then((response) => {
            expect(response.status).to.be.equal(200);

            BaseApi.changePassword(changePasswordRequestBody).then((response: Cypress.Response<HttpResponse>) => {
                expect(response.status).to.be.equal(400);
            });
        });
    });

    it('Change password providing the wrong old password', () => {
        const loginRequestBody: PostLoginRequestBody = {
            username: webUiUsername,
            password: webUiPassword
        }

        const changePasswordRequestBody = {
            oldPassword: 'notTheOldPassword',
            newPassword,
            confirmPassword: newPassword
        }

        BaseApi.login(loginRequestBody).then((response) => {
            expect(response.status).to.be.equal(200);

            BaseApi.changePassword(changePasswordRequestBody).then((response: Cypress.Response<HttpResponse>) => {
                expect(response.status).to.be.equal(401);
            });
        });
    });


    /* it('Reboot device on a non logged in account', () => {
        BaseApi.Reboot({}).then((response: Cypress.Response<HttpResponse>) => {
            expect(response.status).to.be.equal(401);
            if (response.status === 200) {
                cy.wait(120000); // Wait two minutes for the reboot to finish
            }
        });
    }); */
});

