from flask import Blueprint, render_template

static_bp = Blueprint('static_bp', __name__, template_folder='static')


@static_bp.route('/')
def basic_pages0(**kwargs):
    return render_template('index.html')


@static_bp.errorhandler(404)
def page_not_found(e):
    """
    TODO: ADD 404 NOT FOUNT PAGES
    :param e:
    :return:
    """
    return render_template('404.html'), 404
    # return render_template('index.html')


@static_bp.route('/cgi-bin/index.cgi')
def cgi_bin_cgi_legacy_fordward_route(**kwargs):
    """
    Redirect /cgi-bin/index.cgi calls to right home page - FIX for old webui
    :param kwargs:
    :return:
    """
    return render_template("index.html")
