import logging
from flask import request, jsonify
from common_lib.rest.web.midleware.login_required import login_required
from common_lib.uci.UciCli import UciCli
from common_lib.rest.web.web_base_routes import web_base_bp
from common_lib.rest.web.midleware.update_state_validator import update_state_validator

logger = logging.getLogger('flask-backend')


@web_base_bp.route('/ucis', methods=['GET'])
@login_required
@update_state_validator
def web_get_uci():
    try:
        uci_values = {}
        uci_list = request.args

        if uci_list == {}:
            logger.info("Request list is empty, getting all UCIs")
            uci_list = UciCli.get_all_configs()

        logger.info(f"Getting value of ucis: {uci_list}")

        for uciPath in uci_list:
            path_params = uciPath.split('.')

            # This will pad the list with None values if it's too short
            padded_params = (path_params + [None, None, None])[:3]
            result = UciCli.get_value(*padded_params)

            uci_values[uciPath] = result
        logger.info(f"Returning uci values: {uci_values}")
        return jsonify(uci_values), 200
    except Exception as e:
        logger.error(e, exc_info=True)
        return '', 500
