import logging
from flask import jsonify
from common_lib.rest.web.web_base_routes import web_base_bp
from common_lib.rest.web.midleware.login_required import login_required
from common_lib.rest.web.midleware.update_state_validator import update_state_validator
from common_lib.lib.SdfConfig import SdfConfig

logger = logging.getLogger('flask-backend')


@web_base_bp.route('/sdf/<string:instance_name>', methods=['GET'])
@login_required
@update_state_validator
def get_sdf_config(instance_name):
    sdf_config = SdfConfig(instance_name)

    if not sdf_config.valid:
        return '', 500

    config_content = sdf_config.get()

    if config_content is None:
        return '', 404

    return jsonify(config_content), 200
