import json
import logging
import os
import sys

from flask import jsonify

from common_lib.lib.configuration import config
from common_lib.lib.system_info import get_ip_addr
from common_lib.rest.web.web_base_routes import web_base_bp
from common_lib.rest.web.midleware.login_required import login_required
from common_lib.rest.web.midleware.update_state_validator import update_state_validator

logger = logging.getLogger('flask-backend')


@web_base_bp.route('/mqtt/settings', methods=['GET'])
@login_required
@update_state_validator
def web_handle_get_mqtt_settings():
    try:
        ip_addr = get_ip_addr()
    except Exception as e:
        logger.error(e.with_traceback(sys.exc_info()[2]), exc_info=True)
        return '', 500

    try:
        # load from config
        mqttSettings = {
            "hostname": ip_addr,
            "port": config['mqtt_settings']["port"],
            "path": config['mqtt_settings']["path"],
            "protocol": config['mqtt_settings']["protocol"],
            "subscribeTopic": config['mqtt_settings']["subscribe_base_topic"],
            "publishTopic": config['mqtt_settings']["publish_base_topic"]
        }

        mqtt_credentials_settings = config['mqtt_settings']['credentials_file'] if 'credentials_file' in config['mqtt_settings'] else None

        if mqtt_credentials_settings:
            if not os.path.exists(mqtt_credentials_settings):
                raise FileNotFoundError(f"MQTT credentials file not found: {mqtt_credentials_settings}")

            with open(mqtt_credentials_settings, 'r') as config_file:
                mqttSettings.update(json.load(config_file))

    except Exception as e:
        logger.error(e.with_traceback(sys.exc_info()[2]), exc_info=True)
        return '', 500
    logger.debug(f"Returning mqtt settings: {mqttSettings}", exc_info=True)
    return jsonify(mqttSettings), 200
