from flask import Response, request, jsonify
import logging
import json
from common_lib.lib.exceptions import InvalidUploadedFileError
from common_lib.rest.web.midleware.login_required import login_required
from common_lib.lib.certificates import get_ca_certificates, upload_ca_certificate, remove_ca_certificates
from common_lib.rest.web.web_base_routes import web_base_bp
from common_lib.rest.web.midleware.update_state_validator import update_state_validator

logger = logging.getLogger('flask-backend')


@web_base_bp.route('/cacerts', methods=['GET'])
@login_required
@update_state_validator
def web_handle_get_ca_certificates():
    try:
        certificate_list = get_ca_certificates()
        return_dict = {"custom": certificate_list}
        return jsonify(return_dict), 200
    except Exception as ex:
        logger.error(f"Error getting certificates: {ex}", exc_info=True)
        return '', 500


@web_base_bp.route('/cacerts', methods=['POST'])
@login_required
@update_state_validator
def web_handle_upload_ca_certificate():
    try:
        res = upload_ca_certificate(request.files)
        return Response(res, status=200)
    except InvalidUploadedFileError as e1:
        logger.error(e1, exc_info=True)
        return str(e1), 400
    except Exception as e1:
        logger.error(e1, exc_info=True)
        if "No space left on device" in str(e1):
            return '', 507
        return '', 500


@web_base_bp.route('/cacerts', methods=['DELETE'])
@login_required
@update_state_validator
def web_delete_ca_certificates():
    try:
        data = json.loads(request.data)
        res = remove_ca_certificates(data['payload'])
        return jsonify(res), 200
    except Exception as e1:
        logger.error(e1, exc_info=True)
        return '', 500
