import logging
from functools import wraps

from common_lib.lib.fw_update import check_update_firmware_flag

logger = logging.getLogger('flask-backend')


def update_state_validator(f):
    """
    A decorator to use as a middleware. This will test if a device has an update firmware happening. If it is happening,
    will return s status code 409 to infor frontend.
    :param f:
    :return:
    """

    @wraps(f)
    def decorated_function(*args, **kwargs):
        try:
            if check_update_firmware_flag():
                return '', 409
            else:
                return f(*args, **kwargs)
        except Exception as e:
            logger.error(f"Error while checking update firmware lock file: {e}", exc_info=True)
            return '', 500

    return decorated_function
