from common_lib.uci.UciCli import UciCli


class SyslogHandle:

    def __init__(self) -> None:
        self.serverAddress = UciCli.get_value('log', 'syslog', 'server')
        self.protocol = UciCli.get_value('log', 'syslog', 'protocol')
        self.server = None
        self.port = None

        self.enabled = False
        if self.serverAddress:
            self.enabled = True
            (self.server, self.port) = self.serverAddress.split(':')
            self.port = int(self.port)

    def is_enabled(self):
        return self.enabled

    def get_server_address(self):
        return self.serverAddress

    def get_server(self):
        return self.server

    def get_port(self):
        return self.port

    def get_syslog_protocol(self):
        return self.protocol
