from cryptography import x509
from cryptography.hazmat.primitives import hashes
from cryptography.hazmat.backends import default_backend
import logging

logger = logging.getLogger('flask-backend')


def get_device_identifier() -> str:
    """
    Gets a device thumbprint from client-certificate.
    :return: Device's unique thumbprint.
    """
    cert_path = "/mnt/shadow/client-certificate.pem"
    try:
        with open(cert_path, 'rb') as cert_file:
            cert_data = cert_file.read()
            # Load the certificate with the backend specified
            cert = x509.load_pem_x509_certificate(cert_data, default_backend())
            # Use the certificate's thumbprint as a unique identifier
            thumbprint = cert.fingerprint(hashes.SHA256()).hex()
            return thumbprint

    except FileNotFoundError as e:
        logging.error(e, exc_info=True)
        raise e

    except Exception as e:
        logging.error(f"An error occurred while getting the device identifier: {e}", exc_info=True)
        raise e
