import json
import os

config = None

def load_config(config_path='config.json'):
    """
    Load configuration from a JSON file.
    """
    global config

    # Get the directory where this file (configuration.py) is located
    current_dir = os.path.dirname(os.path.abspath(__file__))
    # Go up to backend root (configuration.py is in backend/common_lib/lib/)
    backend_root = os.path.dirname(os.path.dirname(current_dir))
    config_path = os.path.join(backend_root, config_path)

    if not os.path.exists(config_path):
        raise FileNotFoundError(f"Configuration file not found: {config_path}")

    with open(config_path, 'r') as config_file:
        config = json.load(config_file)
