import json
import logging
from common_lib.lib.configuration import config

logger = logging.getLogger('flask-backend')

class SdfConfig:
    _instances = {}

    def __new__(cls, key):
        if key not in cls._instances:
            instance = super().__new__(cls)
            instance.__init__(key)
            cls._instances[key] = instance
        return cls._instances[key]

    def __init__(self, key):
        if not hasattr(self, 'initialized'):
            self.initialized = True
            self.valid = True
            self.key = key
            self._content = self.load_sdf()

    def load_sdf(self):
        config_map = config['sdf_config_map']
        if self.key not in config_map:
            logger.error(f'SDF config for key "{self.key}" not found!', exc_info=True)
            self.valid = False
            return None

        filepath = config_map[self.key]
        try:
            with open(filepath, "r") as f:
                sdf_config = json.load(f)
        except Exception as e:
            logger.error(f'Error reading SDF config file "{filepath}": {e}', exc_info=True)
            self.valid = False
            return None

        return sdf_config

    def get(self):
        return self._content

    @classmethod
    def clear_instances(cls):
        cls._instances.clear()
