from io import BytesIO
from tempfile import TemporaryFile, SpooledTemporaryFile
from flask.wrappers import Request
from common_lib.lib.configuration import config


class MemoryRequest(Request):
    """
    Overrides to config the upload files directory
    """
    def _get_file_stream(self, total_content_length, content_type, filename, content_length):
        max_size = 1024 * 500
        if SpooledTemporaryFile is not None:
            return SpooledTemporaryFile(max_size=max_size, mode="rb+", dir=config['upload_files_dir'])
        elif total_content_length is None or total_content_length > max_size:
            return TemporaryFile(mode="rb+", dir=config['upload_files_dir'])
        return BytesIO()
