import urllib.request
import urllib.error
import ssl
import urllib.parse
import json
from typing import Union
from urllib.request import Request


class HTTPRequestsAPI:

    @staticmethod
    def get(url: str, timeout: Union[int, None] = None, ssl_verify=True):
        request = urllib.request.Request(url=url, method='GET')
        HTTPRequestsAPI.__do_request(request, timeout, ssl_verify)

    @staticmethod
    def post(url: str, payload, timeout: Union[int, None] = None, ssl_verify=True):
        request = urllib.request.Request(url=url, data=json.dumps(payload).encode('utf-8'), method='POST')
        HTTPRequestsAPI.__do_request(request, timeout, ssl_verify)

    @staticmethod
    def put(url: str, payload, timeout: Union[int, None] = None, ssl_verify=True):
        request = urllib.request.Request(url=url, data=json.dumps(payload).encode('utf-8'), method='PUT')
        HTTPRequestsAPI.__do_request(request, timeout, ssl_verify)

    @staticmethod
    def delete(url: str, timeout: Union[int, None] = None, ssl_verify=True):
        request = urllib.request.Request(url=url, method='DELETE')
        HTTPRequestsAPI.__do_request(request, timeout, ssl_verify)

    @staticmethod
    def __do_request(request: Request, timeout: Union[int, None], ssl_verify: bool) -> any:
        request.add_header('Content-Type', 'application/json')
        context = None
        if not ssl_verify:
            context = ssl.create_default_context()
            context.check_hostname = False
            context.verify_mode = ssl.CERT_NONE
        # TODO: create context to actually validate HTTPS connections?
        if timeout is not None:
            r = urllib.request.urlopen(request, timeout=timeout, context=context)
        else:
            r = urllib.request.urlopen(request, context=context)
        return r
