# ChangeLog and Implementations
Hi, you entered the changelog and implementations file where people, like you, updates one application submodule and now the project doesn't run.
The purpose of this file is to serve as a changelog document and to signal versions that implies changes to the "master" application.


## 2026 ...


## 2025 December 19
- Updated file **"configuration.py"**
- Changes to project application should be done before the initial imports, recomended to be before line 4 of **main.py**
```python
...
from common_lib.lib.logger import init_logger
...
```

- Add to main application file(**"main.py"**) the following code:
```python
"""
Init Configuration
"""
from common_lib.lib.configuration import load_config
config_path = os.environ.get("CONFIG_PATH", "./config.json")
load_config(config_path)
```
- Notes: This will allow to specify the configuration file that will be read, if firmware guys don't update the image to enter an OS environment variable, it will be used the default one.
